// =============================================================================
//
//   Charpicker plugin for the KVIrc IRC client
//   Copyright (C) 1999-2000 Stefanek Szymon (kvirc@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#define _KVI_DEBUG_CHECK_RANGE_
#define _KVI_DEBUG_CLASS_NAME_ "KviCharPickerButton"

#include "kvi_charpicker_button.h"
#include "kvi_string.h"

KviCharPickerButton::KviCharPickerButton(QWidget *parent, char display)
	: KviPushButton(parent)
{
	KviStr str;
	str.append(display);
	setText(str.ptr());
	connect(this, SIGNAL(clicked()), this, SLOT(hasBeenClicked()));
}

KviCharPickerButton::~KviCharPickerButton()
{
	// Nothing here
}

void KviCharPickerButton::hasBeenClicked()
{
	emit charPicked(text());
}

#include "m_kvi_charpicker_button.moc"
