#ifndef _KVI_URL_DIALOG_H_INCLUDED_
#define _KVI_URL_DIALOG_H_INCLUDED_

// =============================================================================
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Andrea Parrella (anandrea@iname.com)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include "kvi_window.h"

class QPixmap;

class KviListView;
class KviListViewItem;
class KviMenuBar;
class KviPopupMenu;
class KviProcess;

class KviUrlDialog : public KviWindow
{
	Q_OBJECT
public:
	KviUrlDialog(QPtrList<KviUrl> *g_pList, KviFrame *lpFrm);
	~KviUrlDialog();

	KviListView *m_pUrlList;

	void addUrl(QString url, QString window, QString count, QString timestamp);
	void saveProperties();
protected slots:
	void config();
	void help();
	void saveList();
	void loadList();
	void clear();
	void close_slot();
	void remove();
	void findtext();
	void dblclk_url(KviListViewItem *item);
	void popup(KviListViewItem *item, const QPoint &p, int col);
	void sayToWin(int);
	void processExited(KviProcess *);
protected:
	QPixmap *m_pIcon;
	QPixmap *myIconPtr();
	void resizeEvent(QResizeEvent *);
private:
	KviMenuBar   *m_pMenuBar;
	KviPopupMenu *m_pListPopup; // Dynamic popup menu
	QString       m_szUrl;      // Used to pass urls to sayToWin slot
};

#endif // _KVI_URL_DIALOG_H_INCLUDED_
