/***************************************************************************
 *   Copyright (C) 2004 by Christoph Thielecke                             *
 *   crissi99@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "profilenetworkgeneraloptions.h"

#include <qcheckbox.h>
#include <qspinbox.h>
#include <knuminput.h>
#include <klineedit.h>
#include <qlabel.h>

ProfileNetworkGeneralOptions::ProfileNetworkGeneralOptions(QWidget *parent)
		: ProfileNetworkGeneralOptionsBase(parent)
{
	useConnectionStatusCheckToggled(UseConnectionStatusCheckCheckBox->isChecked());
}


ProfileNetworkGeneralOptions::~ProfileNetworkGeneralOptions()
{}


void ProfileNetworkGeneralOptions::mtuToggled(bool)
{
	if (MtuCheckbox->isChecked())
		MtuSpinbox->setEnabled(true);
	else
		MtuSpinbox->setEnabled(false);
}

void ProfileNetworkGeneralOptions::mruToggled(bool)
{
	if (MruCheckbox->isChecked())
		MruSpinbox->setEnabled(true);
	else
		MruSpinbox->setEnabled(false);
}


void ProfileNetworkGeneralOptions::useConnectionStatusCheckToggled(bool)
{
	if (UseConnectionStatusCheckCheckBox->isChecked())
	{
		ConnectionStatusCheckIntervalNumInput->setEnabled(true);
		ConnectionStatusSuccessCountNumInput->setEnabled(true);
		PingIntervalLabel->setEnabled(true);
		PingSuccessCountLabel->setEnabled(true);
	}
	else
	{
		ConnectionStatusCheckIntervalNumInput->setEnabled(false);
		ConnectionStatusSuccessCountNumInput->setEnabled(false);
		PingIntervalLabel->setEnabled(false);
		PingSuccessCountLabel->setEnabled(false);
	}
}

void ProfileNetworkGeneralOptions::pingIpAfterConnectToggled(bool)
{
	if (PingCheckBox->isChecked())
		PingIPLineEdit->setEnabled(true);
	else
		PingIPLineEdit->setEnabled(false);
}

void ProfileNetworkGeneralOptions::useReconnectDelayToggled(bool)
{
	if (UseReconnectDelayCheckBox->isChecked())
		ReconnectDelayNumInput->setEnabled(true);
	else
		ReconnectDelayNumInput->setEnabled(false);
}

void ProfileNetworkGeneralOptions::useReconnectAfterDisconnectToggled(bool)
{
	if (DoReconnectAfterConnectionLostCheckBox->isChecked())
	{
			if (UseReconnectDelayCheckBox->isChecked())
		ReconnectDelayNumInput->setEnabled(true);
	else
		ReconnectDelayNumInput->setEnabled(false);

	UseReconnectDelayCheckBox->setEnabled(true);
	}
	else
	{
		ReconnectDelayNumInput->setEnabled(false);
		UseReconnectDelayCheckBox->setEnabled(false);
	}
}

void ProfileNetworkGeneralOptions::UseDnsUpdateToggled(bool)
{
 //   UseDnsUpdate->setEnabled(UseDnsUpdateCheckBox->isChecked());
}





