/***************************************************************************
                          weatherlib.h  -  description
                             -------------------
    begin                : Wed Jul 5 2000
    copyright            : (C) 2000 by Ian Reinhart Geiser
    email                : geiseri@msoe.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef WEATHERLIB_H
#define WEATHERLIB_H
#include <qstring.h>
#include <qlist.h>
#include <qregexp.h>

/**
  *@author Ian Reinhart Geiser
  */

class weatherlib{
public: 
	weatherlib();
	~weatherlib();
  /** This is will tokenize the data and process it. */
  void processData(QString s, bool mode);
  /**  */
  QString getTemp();
  /** Will return the wind data  as a QString */
  QString getWindData();
  /** Will return the current airpressure */
  QString getPressure();
  /** This will reuturn the index of the current ICON that should be displayed for the user. */
  QString getCurrent();
  /** Returns the date of the weather data */
  QString getDate(int GMT_Offset);
  /** return the current time of the sample... */
  QString getTime();
  /**  */
  QString getWeatherText();
  /** return the weather text */
  QString getCurrentText();
  /** return the visability */
  QString getVisability();
  /** Returns the current cover */
  QString getCover();
private: // Private methods
  /** Parse out the current pressure. */
  void parsePressure( QString s);
  /** Parse the current visability. */
  void parseVisability( QString s);
  /** Parse out the current time. */
  void parseTime(QString s);
  /** Parse out the current temperature */
  void parseTemperature(QString s);
  /** Parse out the current date. */
  void parseDate(QString s);
  /** Parse the current weather conditions */
  void parseCurrent(QString s);
  /** Parse the current cover type */
  void parseCover( QString s);
	/** Parse the wind speed */
	void parseWindSpeed( QString s);
	QString qsCover;
	QString qsCurrent;
	QString qsDate;
	QString qsPressure;
	QString qsTemperature;
	QString qsTime;
	QString qsVisability;
	QString qsWindSpeed;
	QString qsWindDirection;
	/** Calm wind */
  QRegExp WindRegExp1;
  /** Wind with Gusts */
  QRegExp WindRegExp2;
  /** Steady Wind */
  QRegExp WindRegExp3;
	/** Current Visability 1*/
  QRegExp VisRegExp1;
	/** Current Visability 2*/ 			
	QRegExp VisRegExp2; 			
	QRegExp TempRegExp1; 		
	QRegExp TempRegExp2; 		
	QRegExp TempRegExp3; 		
	QRegExp TempRegExp4; 		
	QRegExp CoverRegExp1; 		
	QRegExp CoverRegExp2; 		
	QRegExp CoverRegExp3; 		
	QRegExp CoverRegExp4; 		
	QRegExp CoverRegExp5;
	QRegExp CoverRegExp6; 		
	QRegExp CurrentRegExp1;
	QRegExp CurrentRegExp2;
	QRegExp CurrentRegExp3;
	QRegExp TimeRegExp1; 		
 	QRegExp DateRegExp1;
	QRegExp PressRegExp1;	
	QRegExp PressRegExp2;		
	bool MetricMode;
	/** The current weather state outside */
	QString theWeather;
	int clouds;
	bool weatherGood;
};

#endif
