//
// C++ Implementation: serenityhandler
//
// Author: Remi Villatel <maxilys@tele2.fr>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "serenityhandler.h"
#include "serenityclient.h"
#include "pixmaps.h"
#include "embeddata.h"

bool SerenityHandler::m_initialized = false;
int SerenityHandler::m_borderSize = 6;	// Fixed value.
bool SerenityHandler::m_useFrameColor = false;
bool SerenityHandler::m_zenBorder = false;
bool SerenityHandler::m_maxCorner = true;
bool SerenityHandler::m_noMaxFrame = false;
int SerenityHandler::m_gradientContrast = 5;
//
int SerenityHandler::m_titlePosition = 0;
int SerenityHandler::m_titleSize = 20;		// + borderSize * 2
int SerenityHandler::m_buttonSize = 20;
int SerenityHandler::m_buttonStyle = 0;
int SerenityHandler::m_gradientType = 0;
bool SerenityHandler::m_alternateSinking = false;
int SerenityHandler::m_iconTheme = 0;
bool SerenityHandler::m_styledMenu = true;
bool SerenityHandler::m_extraSpacing = false;
bool SerenityHandler::m_centerTitle = true;
bool SerenityHandler::m_noTitleFrame = false;
//
bool SerenityHandler::m_closerWide = false;
bool SerenityHandler::m_menuWide = false;
bool SerenityHandler::m_maxWide = false;
bool SerenityHandler::m_minWide = false;
bool SerenityHandler::m_stickyWide = false;
bool SerenityHandler::m_aboveWide = false;
bool SerenityHandler::m_belowWide = false;
bool SerenityHandler::m_helpWide = false;

int SerenityHandler::m_closerGlow = 0;
int SerenityHandler::m_menuGlow = 2;
int SerenityHandler::m_maxGlow = 1;
int SerenityHandler::m_minGlow = 3;
int SerenityHandler::m_stickyGlow = 5;
int SerenityHandler::m_aboveGlow = 6;
int SerenityHandler::m_belowGlow = 7;
int SerenityHandler::m_helpGlow = 4;
//
QColor SerenityHandler::listColor0(255, 0, 0);
QColor SerenityHandler::listColor1(0, 255, 0);
QColor SerenityHandler::listColor2(0, 192, 255);
QColor SerenityHandler::listColor3(255, 160, 0);
QColor SerenityHandler::listColor4(255, 0, 255);
QColor SerenityHandler::listColor5(255, 255, 0);
QColor SerenityHandler::listColor6(128, 128, 128);
QColor SerenityHandler::listColor7(255, 255, 255);

SerenityHandler::SerenityHandler()
{
	reset(0);
}

SerenityHandler::~SerenityHandler()
{
	Pixmaps::deletePixmaps();
	qCleanupImages_KWinSerenity();
	m_initialized = false;
}

bool SerenityHandler::reset(unsigned long) // unsigned long changed
{
	readConfig();

	Pixmaps::deletePixmaps();
	Pixmaps::createPixmaps();
	qInitImages_KWinSerenity();

	m_initialized = true;
	return true;
}

KDecoration* SerenityHandler::createDecoration(KDecorationBridge *bridge)
{
	return new SerenityClient(bridge, this);
}

#if KDE_IS_VERSION(3, 4, 0)
bool SerenityHandler::supports(Ability ability)
{
	switch (ability)
	{
		case AbilityAnnounceButtons:
		case AbilityButtonMenu:
		case AbilityButtonOnAllDesktops:
		case AbilityButtonSpacer:
		case AbilityButtonHelp:
		case AbilityButtonMinimize:
		case AbilityButtonMaximize:
		case AbilityButtonClose:
		case AbilityButtonAboveOthers:
		case AbilityButtonBelowOthers:
		{
			return true;
		}
		case AbilityButtonShade:
		default:
		{
			return false;
		}
	};
}
#endif

void SerenityHandler::readConfig()
{
	KConfig config("kwinserenityrc");
	m_gradientContrast = config.readNumEntry("/Qt/KDE/contrast", 5);

	config.setGroup("General");
	m_useFrameColor = config.readBoolEntry("UseFrameColor", false);
	m_zenBorder = config.readBoolEntry("ZenBorder", false);
	m_maxCorner = config.readBoolEntry("MaximizedCorner", true);
	m_noMaxFrame = config.readBoolEntry("NoMaximizedFrame", false);
	//
	m_titlePosition = config.readNumEntry("TitlePosition", 0);
	m_titleSize = config.readNumEntry("TitleSize", 20); // +4 +4 (top & mid spacers)
	if (m_titleSize & 1)	// Odd size
		m_titleSize++;
	m_buttonSize = m_titleSize;
	m_buttonStyle = config.readNumEntry("ButtonStyle", 0);
	m_gradientType = config.readNumEntry("GradientStyle", 0);
	m_alternateSinking = config.readBoolEntry("AlternateSunkenEffect", true);
	m_iconTheme = config.readNumEntry("IconTheme", 0);
	m_styledMenu = config.readBoolEntry("StyledMenu", true);
	m_extraSpacing = config.readBoolEntry("ExtraSpacing", false);
	m_centerTitle = config.readBoolEntry("CenterTitle", true);
	m_noTitleFrame = config.readBoolEntry("NoTitleFraming", false);
	//
	m_closerWide = config.readBoolEntry("WideCloser", false);
	m_menuWide = config.readBoolEntry("WideMenu", false);
	m_maxWide = config.readBoolEntry("WideMaximizer", false);
	m_minWide = config.readBoolEntry("WideMinimizer", false);
	m_stickyWide = config.readBoolEntry("WideSticker", false);
	m_aboveWide = config.readBoolEntry("WideAbove", false);
	m_belowWide = config.readBoolEntry("WideBelow", false);
	m_helpWide = config.readBoolEntry("WideHelp", false);

	m_closerGlow = config.readNumEntry("CloserGlow", 0);
	m_menuGlow = config.readNumEntry("MenuGlow", 2);
	m_maxGlow = config.readNumEntry("MaximizerGlow", 1);
	m_minGlow = config.readNumEntry("MinimizerGlow", 3);
	m_stickyGlow = config.readNumEntry("StickerGlow", 5);
	m_aboveGlow = config.readNumEntry("AboveGlow", 6);
	m_belowGlow = config.readNumEntry("BelowGlow", 7);
	m_helpGlow = config.readNumEntry("HelpGlow", 4);
	//
	QColor defaultColor0(255, 0, 0);
	QColor defaultColor1(0, 255, 0);
	QColor defaultColor2(0, 192, 255);
	QColor defaultColor3(255, 160, 0);
	QColor defaultColor4(255, 0, 255);
	QColor defaultColor5(255, 255, 0);
	QColor defaultColor6(128, 128, 128);
	QColor defaultColor7(255, 255, 255);
	//
	listColor0 = config.readColorEntry("Color0", &defaultColor0);
	listColor1 = config.readColorEntry("Color1", &defaultColor1);
	listColor2 = config.readColorEntry("Color2", &defaultColor2);
	listColor3 = config.readColorEntry("Color3", &defaultColor3);
	listColor4 = config.readColorEntry("Color4", &defaultColor4);
	listColor5 = config.readColorEntry("Color5", &defaultColor5);
	listColor6 = config.readColorEntry("Color6", &defaultColor6);
	listColor7 = config.readColorEntry("Color7", &defaultColor7);
}

#include "serenityhandler.moc"
