#include "kwlantraywin.h"
//#include "wlanlib.h"
#include "kwlaninterface.h"
#include "kdialup.h"
#include "kstartsupplicantdlg.h"
#include "kwlansettingsdlg.h"
#include "globals.h"

#include <kstdaction.h>
#include <kpopupmenu.h>
#include <kaction.h>
#include <qtooltip.h>
#include <kiconloader.h>
#include <qpixmap.h>
#include <klocale.h>
#include <kdebug.h>
#include <kpassivepopup.h>





KWlanTrayWin::KWlanTrayWin(QWidget *parent, const char *name)
    : KSystemTray(parent, name)
{
    int id;
    m_interface = 0L;
    m_ifname="";
    //m_interfaceUp = FALSE;
    //actionCollection()->remove( actionCollection()->action( "quit" ) );
    m_quit = KStdAction::quit( this, SIGNAL( quitSelected() ), actionCollection() );
    m_about = KStdAction::aboutApp( this, SIGNAL( aboutSelected() ), actionCollection() );
    m_interfaceEnableMenu = new KAction(this,"interfaceEnable");
    connect (m_interfaceEnableMenu,SIGNAL(activated()),this, SLOT(interfaceEnable()));

    setPixmap(loadIcon("kwlan"));
    m_tooltip = new KWlanToolTip(this);
    m_profiles.setAutoDelete(TRUE);
    m_profileMenu = new KPopupMenu();
    connect (m_profileMenu, SIGNAL(activated(int )),SLOT(selectProfile(int )));
    m_wpaMenu = new KPopupMenu();
    m_wpaMenu->insertItem(i18n("Start WPA Supplicant"),WPASTARTID);
    m_wpaMenu->setItemParameter(WPASTARTID,WPASTARTID);
    m_wpaMenu->insertItem(i18n("Stop WPA Supplicant"),WPASTOPID);
    m_wpaMenu->setItemParameter(WPASTOPID,WPASTOPID);
    m_wpaMenu->insertItem(i18n("Log Viewer"),WPALOGID);
    m_wpaMenu->setItemParameter(WPALOGID,WPALOGID);
    m_wpaMenu->insertItem(i18n("Settings"),WPASETTINGSID);
    m_wpaMenu->setItemParameter(WPASETTINGSID,WPASETTINGSID);
    connect (m_wpaMenu,SIGNAL(activated(int )), this, SLOT(handleWpaMenuEvent(int )));
    m_wpaMenu->setItemEnabled(WPASTOPID,FALSE);
    
    m_timer = new QTimer(this);
    if (m_timer){
        connect (m_timer, SIGNAL(timeout()),SLOT(updateIcon()));
        m_timer->start(100,FALSE);
    }
    m_configuration = 0L;
}

KWlanTrayWin::~KWlanTrayWin() {
    if (m_timer){
        m_timer->stop();
        delete (m_timer);
    } 
    delete m_tooltip;
    m_tooltip = 0;
}

void KWlanTrayWin::setInterface(KWlanInterface *interface)
{
    if (!interface) return;
    m_interface = interface;
    connect (m_interface, SIGNAL(interfaceUp( bool )), this, SLOT (setInterfaceEnableMenu( bool )));
    connect (this, SIGNAL(interfaceEnable( bool )), m_interface, SLOT (enableInterface(bool)));
    connect (m_interface, SIGNAL(interfaceGone(KWlanInterface*)), this, SLOT (slotInterfaceGone(KWlanInterface* )));
    connect (this, SIGNAL(viewLog()),m_interface,SLOT(logViewer()));
    connect (this, SIGNAL(editProfiles()), m_interface,SLOT(editProfiles()));
    connect (this, SIGNAL(scan()), m_interface, SLOT(slotScan()));
    connect (this, SIGNAL(profileChanged(QString)), m_interface, SLOT(profileActivate(QString)));
    connect (m_interface, SIGNAL(wpaStatusChanged(bool)), this, SLOT(enableStartWpaMenu(bool)));
    connect (m_interface,SIGNAL(sigMessage( QString )),this,SLOT(say( QString )));
    m_confFile = QString("kwlanrc.") + interface->getInterfaceName();
    m_configuration = new Configuration(m_confFile);
    updateNetworks();

}

 
void KWlanTrayWin::contextMenuAboutToShow( KPopupMenu *r ) {
    QString *prof, curProf;
    updateNetworks();
    if (! m_interface) return;
    curProf = m_interface->getCurrentProfile();
    //kdDebug() << "Current profile" << curProf << endl;
    int id;
    r->clear();
    r->insertTitle(SmallIcon ("kwlan"), "KWlan - KDE Connection Manager");
    // Now fill int the profiles into profile menu
    id = 1;
    m_profileMenu->clear();
    //if (m_interfaceUp && (m_interface->getType()!=KWlanInterface::PPP)){
    if (m_interface->getType()!=KWlanInterface::PPP){
            m_profileMenu->insertItem(i18n("Edit profiles"),id);
        m_profileMenu->setItemParameter(id,id);
        id++;
        if (m_interface->getInterfaceData().wirelessDevice)
        {
            m_profileMenu->insertItem(i18n("Scan"),id);
            m_profileMenu->setItemParameter(id,id);
            id++;
        }
        if (!m_profiles.isEmpty())
        {
            m_profileMenu->insertSeparator(id);
            id++;
        }
        prof = m_profiles.first();
        while (prof){
            //kdDebug() << "Inserting profile " << *prof << endl;
            m_profileMenu->insertItem(*prof,id);
            m_profileMenu->setItemParameter(id,id);
            if (*prof == curProf)
                m_profileMenu->setItemChecked(id, TRUE);
            else 
                m_profileMenu->setItemChecked(id, FALSE);
            prof=m_profiles.next();
            id++;
        }
        r->insertItem(i18n("Profiles"),m_profileMenu);
        r->insertItem(i18n("Wpa"),m_wpaMenu);
        r->insertSeparator();
    }
    //now set the interface enable / disable menu
    QString enableMenu;
    if (m_interface->getInterfaceData().up) enableMenu = i18n("Disable");
    else enableMenu = i18n("Enable");
    m_interfaceEnableMenu->setText(enableMenu);
    m_interfaceEnableMenu->plug(r);
    r->insertSeparator();
    if (m_interface->getType() != KWlanInterface::PPP) 
    {
        m_about->plug( r );
        m_quit->plug( r );
    }
    
}

void KWlanTrayWin::clearProfiles()
{
    while (!m_profiles.isEmpty()) m_profiles.removeFirst();
}

void KWlanTrayWin::updateNetworks()
{
    QStringList networks;
    clearProfiles();
    if (!m_interface) return;
    networks= m_interface->listProfiles();
    for (QStringList::Iterator it=networks.begin();it != networks.end();it++){
        m_profiles.append(new QString(*it));
    }
}

void KWlanTrayWin::setInterfaceEnableMenu( bool up)
{
    if (!m_interface) return;
    //m_interfaceUp = up;

}
            
void KWlanTrayWin::interfaceEnable()
{
    if (!m_interface) return;
    emit (interfaceEnable(!m_interface->getInterfaceData().up));
}
const QString & KWlanTrayWin::getInterfaceName() const {
    return m_ifname;
}
        
void KWlanTrayWin::slotSettings()
{
    if (!m_interface) return;
    KWlanSettingsDlg *settings = new KWlanSettingsDlg();
    Configuration *configuration = m_interface->getConfiguration();
    settings->setConfiguraton( configuration);

    if (!settings) return;
    settings->setCaption(QString(i18n("Settings for %1")).arg(m_ifname));
    settings->show();
    settings->exec();
}


void KWlanTrayWin::updateIcon()
{
    //QPixmap trayIcon;
    // Do we have a wireless interface?
    if (!m_interface ) return;
    interfaceData data = m_interface->getInterfaceData();
    QString statusIcon = getIcon();
    if (data.connected)
    {
        if (data.prevTxBytes == data.txBytes)
        {
            if (data.prevRxBytes == data.rxBytes) statusIcon +=QString("-none");
            else statusIcon +=QString("-rx");
        }
        else if (data.prevRxBytes == data.rxBytes) statusIcon +=QString("-tx");
        else  statusIcon += QString("-both");
    }
    else statusIcon += QString("-disconnected") ;
    setPixmap(loadIcon(statusIcon));
}


void KWlanTrayWin::setInterfaceName(const QString &ifname)
{
    m_ifname = ifname;
}

void KWlanTrayWin::setIpAddress(const QString &ipaddress){
    m_ipaddress = ipaddress;
}


void KWlanTrayWin::selectProfile(int id)
{
    //kdDebug() <<"select Profile " <<m_profileMenu->text(id) << endl;
    switch (id)
    {
        case 1:
            emit (editProfiles());
            break;
        case 2:
            emit(scan());
            break;
        default:
            emit profileChanged(m_profileMenu->text(id));
    }
}

void KWlanTrayWin::wpaStart()
{
    QString driver;
    if (!m_interface) return;
    if (m_interface->getInterfaceData().wirelessDevice)
    {
        KStartSupplicantDlg *startSupplicant = new KStartSupplicantDlg();
        if (!startSupplicant) return;
        if (!m_configuration) return;
        m_configuration->readDriver(driver);
        startSupplicant->setData( & m_interface->getInterfaceName() ,& driver);
        startSupplicant->show();
        startSupplicant->exec();
        if (startSupplicant->m_start){
            m_interface->startWpa(startSupplicant->getDriver());
        }
    }

    else {
        //wired device, so drvier is wired
        m_interface->startWpa(QString("wired"));
    }
}

void KWlanTrayWin::wpaStop()
{
    if (!m_interface) return;
    m_interface->stopWpa();
}
void KWlanTrayWin::handleWpaMenuEvent(int menu)
{
    switch (menu)
    {
        case WPASTARTID:
            wpaStart();
            break;
        case WPASTOPID:
            wpaStop();
            break;
        case WPALOGID:
            emit (viewLog());
            break;
        case WPASETTINGSID:
            slotSettings();
            break;
    }
}

void KWlanTrayWin::enableStartWpaMenu(bool enable)
{
    m_wpaMenu->setItemEnabled(WPASTARTID,!enable);
    m_wpaMenu->setItemEnabled(WPASTOPID,enable);
    m_wpaMenu->setItemEnabled(WPALOGID,enable);
}

void KWlanTrayWin::slotInterfaceGone(KWlanInterface *interface)
{
    kdDebug() << "Closing traywin..." << endl;
    m_interface=0L;
    m_timer->stop();
    close();
    deleteLater();
}

void KWlanTrayWin::slotShowTrayWin(QString interface, bool showWin)
{
    if (interface != m_ifname) return;
    if (showWin) show();
    else hide();
}


void KWlanTrayWin::mousePressEvent ( QMouseEvent * event )
{
    if (debugOutput) kdDebug() << "Tray Win clicked" << endl;
    if ( rect().contains( event->pos() ) )
        emit sigTrayWinClicked(m_ifname);
    //slotClicked(event);
   KSystemTray::mousePressEvent(event);
}

QString KWlanTrayWin::getIcon()
{
    QString statusIcon = QString("");
    wirelessData wData = m_interface->getWirelessData();
    if (m_interface->getType() == KWlanInterface::PPP)
        statusIcon = "kwlan/dialup";
    else if (!m_interface->getInterfaceData().wirelessDevice)
        statusIcon = "kwlan/wired";
    else {
        if (m_interface->getInterfaceData().connected)
        {
            int index = wData.linkQualityNum;
            if (index > 66)
                statusIcon = QString("kwlan/wireless3");
            else if (index > 33)
                statusIcon = QString("kwlan/wireless2");
            else
                statusIcon = QString("kwlan/wireless1");
        }
        else statusIcon = QString("kwlan/wireless");
    }
    return statusIcon;
}

void KWlanTrayWin::say(QString message)
{
    if (this->isVisible())
        KPassivePopup::message("KWlan", message, kapp->miniIcon(), this);
}
    
KWlanToolTip::KWlanToolTip(QWidget *parent): QToolTip(parent) {
}
    
KWlanToolTip::~KWlanToolTip() {
    
}
        
void KWlanToolTip::maybeTip(const QPoint &p) {
    QString tooltip;
    KWlanTrayWin *parent = (KWlanTrayWin *)parentWidget();
        
    // We can't show tooltip if no interface was specified
    if (!parent->getInterface())
    {
        kdDebug() << "No interface for tooltip found" << endl;
        return;
    }
    const QString &ifname = parent->getInterfaceName();
    interfaceData data = parent->getInterface()->getInterfaceData();
    wirelessData wData;
    if (data.wirelessDevice)
         wData = parent->getInterface()->getWirelessData();
    //QString network = parent->getProfile();
    QString network = parent->getInterface()->getCurrentProfile();
    // Get the URLs of the icons
    QString dialup,wireless_connected,wireless_disconnected,wired_connected,wired_disconnected;
    KIconLoader *kIcon = new KIconLoader();
    dialup = kIcon->iconPath("kwlan/dialup",KIcon::Desktop);
    wireless_connected = kIcon->iconPath(parent->getIcon()+QString("-none"),KIcon::Desktop);
    wireless_disconnected = kIcon->iconPath("kwlan/wireless-disconnected",KIcon::Desktop);
    wired_connected = kIcon->iconPath("kwlan/wired-none",KIcon::Desktop);
    wired_disconnected = kIcon->iconPath("kwlan/wired-disconnected",KIcon::Desktop);
    if (data.connected) {
        if (parent->getInterface()->getType() == KWlanInterface::PPP)
        {
            tooltip = QString("<center><img align=center src=%1></center>").arg(dialup);
        }
        if (data.wirelessDevice) {
            tooltip = QString("<center><img align=center src=%1></center>").arg(wireless_connected);
        }
        else {
            tooltip = QString("<center><img align=center src=%1></center>").arg(wired_connected);
        }
        tooltip += QString("<center><table border=0 bgcolor=#000000 cellspacing=1 cellpadding=1>");
        if (network.isEmpty())
            tooltip += QString(i18n("<tr><td colspan=2 bgcolor=#04CC1A><center><b>Interface:</b> [ %1 ]</center></td>")).arg(ifname);
        else
            tooltip += QString(i18n("<tr><td colspan=2 bgcolor=#04CC1A><center><b>Interface:</b> [ %1 ]<br>Connected to %2</b></center></td>")).arg(ifname,network);        
        if (data.wirelessDevice) {
            if (wData.essid.isEmpty())
                tooltip += QString(i18n("<tr><td bgcolor=#CCCCCC><b>Connected to:</b></td><td bgcolor=#CCCCCC><center>Hidden</center></td></tr>"));
            else
            tooltip += QString(i18n("<tr><td bgcolor=#CCCCCC><b>Connected to:</b></td><td bgcolor=#CCCCCC><center>%1</center></td></tr>")).arg(wData.essid);
            
            if (!wData.bitRate.isEmpty())
                tooltip += QString(i18n("<tr><td bgcolor=#EEEEEE><b>Bitrate:</b></td><td bgcolor=#EEEEEE><center>%1 Mbit/s</center></td></tr>")).arg(wData.bitRate);
            if (!wData.linkQuality.isEmpty())
                tooltip += QString(i18n("<tr><td bgcolor=#CCCCCC><b>Link quality:</b></td><td bgcolor=#CCCCCC><center>%1</center></td></tr>")).arg(wData.linkQuality);
            if (!wData.signal.isEmpty())
                tooltip += QString(i18n("<tr><td bgcolor=#EEEEEE><b>Signal Level:</b></td><td bgcolor=#EEEEEE><center>%1</center></td></tr>")).arg(wData.signal);
            if (!wData.frequency.isEmpty())
                tooltip += QString(i18n("<tr><td bgcolor=#CCCCCC><b>Frequency:</b></td><td bgcolor=#CCCCCC><center>%1</center></td></tr>")).arg(wData.frequency);
            if (!wData.channel.isEmpty())
                tooltip += QString(i18n("<tr><td bgcolor=#EEEEEE><b>Channel:</b></td><td bgcolor=#EEEEEE><center>%1</center></td></tr>")).arg(wData.channel);
        }
        tooltip += QString(i18n("<tr><tr><td bgcolor=#CCCCCC><b>IP address:</b></td><td bgcolor=#CCCCCC><center>%1</center></td></tr>")).arg(data.ipAddress);
        tooltip += QString(i18n("<tr><td bgcolor=#EEEEEE><b>Netmask:</b></td><td bgcolor=#EEEEEE><center>%1</center></td></tr>")).arg(data.subnetMask);
        tooltip += QString(i18n("<tr><tr><td bgcolor=#CCCCCC><b>Broadcast address:</b></td><td bgcolor=#CCCCCC><center>%1</center></td></tr>")).arg(data.broadcastAddress);
        tooltip += QString(i18n("<tr><td bgcolor=#EEEEEE><b>Bytes received:</b></td><td bgcolor=#EEEEEE><center>%1</center></td></tr>")).arg(data.rxString);
        tooltip += QString(i18n("<tr><tr><td bgcolor=#CCCCCC><b>Bytes sent:</b></td><td bgcolor=#CCCCCC><center>%1</center></td></tr>")).arg(data.txString);
        tooltip += QString(i18n("<tr><td bgcolor=#EEEEEE><b>Packets received:</b></td><td bgcolor=#EEEEEE><center>%1</center></td></tr>")).arg(data.rxPackets);
        tooltip += QString(i18n("<tr><tr><td bgcolor=#CCCCCC><b>Packets sent:</b></td><td bgcolor=#CCCCCC><center>%1</center></td></tr>")).arg(data.txPackets);
        tooltip += QString("</table></center>");
    }
    else {
        if (data.wirelessDevice) {
            tooltip = QString("<center><img align=center src=%1></center>").arg(wireless_disconnected);
        }
        else {
            tooltip = QString("<center><img align=center src=%1></center>").arg(wired_disconnected);
        }
        tooltip += QString("<center><table border=0 bgcolor=#000000 cellspacing=1 cellpadding=1>");
        tooltip += QString(i18n("<tr><td bgcolor=#DD0500><center>[ %1 ] <b>is disconnected</b></center></td></tr>")).arg(ifname);
        if (data.wirelessDevice && wData.radioOff) {
            tooltip += QString(i18n("<tr><td bgcolor=#CCCCCC><center>The radio is off</center></td></tr>"));
        }
        tooltip += QString("</table></center>");
    }
                 
    tip(parent->rect(), tooltip);
}

