#ifndef _KWLANKICKER_H_
#define _KWLANKICKER_H_
/** KWlan
 *
 *  This File is part of KWlan, a network Manager for KDE.
 *  KWlan is distributed under LGPL license.
 *
 *	@author Thomas Michel <tom.michel@arcor.de>
 */


#include <sys/types.h>
#include <ksystemtray.h>
#include <qtooltip.h>
#include <qstring.h>
#include <qptrlist.h>
#include <kpopupmenu.h>
#include <qtimer.h>

class QWidget;
class KAction;
class KWlanInterface;
class Configuration;

// IDs for WPA MEnu
#define WPASTARTID 1
#define WPASTOPID 2
#define WPALOGID 3
#define WPASETTINGSID 4

// Tooltip class to show extended link information - "KGet approach"

class KWlanToolTip : public QToolTip {

    public:
     	KWlanToolTip(QWidget *parent);
    virtual ~KWlanToolTip();
	
    protected:
       void maybeTip(const QPoint &);
};


// Class to show status in systray

class KWlanTrayWin : public KSystemTray
{
    Q_OBJECT
    public:
        KWlanTrayWin(QWidget *parent=0, const char *name=0);
        virtual ~KWlanTrayWin();
        void contextMenuAboutToShow ( KPopupMenu * );
        bool isConnected() const;
        const QString & getInterfaceName() const;
        void clearProfiles();
        void setInterface(KWlanInterface *interface);
        KWlanInterface* getInterface()
        {
            return m_interface;
        }
        void setProfile(QString profile)
        {
            m_profile = profile;
        }
        QString getProfile()
        {
            return m_profile;
        }
        void setInterfaceName(const QString &ifname);
        QString getIcon();

    signals:
        void clicked();
        void aboutSelected();
        void profileChanged(QString profile);
        void interfaceEnable(bool enable);
        void viewLog();
        void editProfiles();
        void scan();
        void sigTrayWinClicked(QString);

        
    public slots:
        void updateIcon();
        void setIpAddress(const QString &ipaddress);
        void updateNetworks();
        void setInterfaceEnableMenu(bool up);
        void interfaceEnable();
        void wpaStart();
        void wpaStop();
        void handleWpaMenuEvent(int menu);
        void enableStartWpaMenu(bool enable);
        void slotInterfaceGone(KWlanInterface  *interface);
        void slotShowTrayWin(QString interface, bool showWin);
        void mousePressEvent ( QMouseEvent * event );
        void slotSettings();
        void say (QString message);
        //void slotClicked(QMouseEvent*);

    protected:
        //void mouseReleaseEvent( QMouseEvent * );
        QString m_ifname;
        QString m_ipaddress;
        KAction *m_quit, *m_about,  *m_interfaceEnableMenu;
        KWlanToolTip *m_tooltip;
        QTimer *m_timer;
    private slots:
        void selectProfile(int id);
    private:
        QPtrList<QString> m_profiles;
        //bool m_interfaceUp;
        KPopupMenu *m_profileMenu, *m_wpaMenu;
        KWlanInterface *m_interface;
        QString m_profile;
        QString m_confFile;
        Configuration *m_configuration;
        //KWlanMainWin *m_mainWin;
};

#endif
