/*
   
        (c) 2006 by Thomas Michel <tom.michel@arcor.de>

        Kwlan is free software; you can redistribute it and/or modify
        it under the terms of the GNU Library General Public License as
        published by the Free Software Foundation; either version 2 of
        the License, or (at your option) any later version.

        Kwlan is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        GNU Library General Public License for more details.

        You should have received a copy of the GNU Library General Public License
        along with this library; see the file COPYING.LIB.  If not, write to
        the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
        Boston, MA 02110-1301, USA.
*/

#ifndef __DIALUP__
#define __DIALUP__

#define PPP_PEERS "/etc/ppp/peers/kwlan"

#include <qstring.h>

class QStringList;



struct dialupData
{
    dialupData(): connectionType(ANALOG),
    noipdefault(TRUE),
    defaultroute(TRUE),
    replacedefaultroute(TRUE),
    noauth(TRUE),
    persist(TRUE),
    usepeerdns(TRUE),
    scriptBeforeDisconnectRoot(FALSE),
    scriptAfterConnectRoot(FALSE),
    hidepassword(TRUE),
    storepassword(FALSE)
    {}
    enum type {
        PPPOE,
        ISDN,
        ANALOG
    };
    type  connectionType;
    bool noipdefault;
    bool defaultroute;
    bool replacedefaultroute;
    bool noauth;
    bool  persist;
    bool usepeerdns;
    QString interface;
    QString initString;
    QString password;
    QString user;
    QString number;
    QString scriptBeforeDisconnect;
    QString scriptAfterConnect;
    bool scriptBeforeDisconnectRoot;
    bool scriptAfterConnectRoot;
    bool hidepassword;
    bool storepassword;
};



QStringList listDialupNetworks();

#endif
