/*
   
        (c) 2006 by Thomas Michel <tom.michel@arcor.de>
        SuProcessBase is Copyright (c) 2006 by Valentine Sinitsyn <e_val@inbox.ru>.

        Kwlan is free software; you can redistribute it and/or modify
        it under the terms of the GNU Library General Public License as
        published by the Free Software Foundation; either version 2 of
        the License, or (at your option) any later version.

        Kwlan is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        GNU Library General Public License for more details.

        You should have received a copy of the GNU Library General Public License
        along with this library; see the file COPYING.LIB.  If not, write to
        the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
        Boston, MA 02110-1301, USA.
*/

#ifndef SUPROCESSBASE_H
#define SUPROCESSBASE_H

#include <qobject.h>
#include <qcstring.h>
#include <qstring.h>

class KProcess;




class SuProcessBase: public QObject {
  Q_OBJECT
  
  public:
    enum Communication {NoCommunication = 0, Stdin = 1, Stdout = 2, Stderr = 4};  
    enum RunMode {DontCare, NotifyOnExit, Block};
    
    SuProcessBase(QObject *parent = 0, const char *name = 0);
    virtual ~SuProcessBase();
    
    SuProcessBase& operator << (const QString &arg);
    void clearArguments();
    
    virtual bool start(RunMode runmode = NotifyOnExit, 
                       Communication comm = NoCommunication);
    
    //bool isRunning() const;    
    int exitStatus() const;

    static QString quote(const QString &arg);    
    
  signals:
    void processExited(SuProcessBase *);
    void receivedStdout(SuProcessBase *, char *, int);
    void receivedStderr(SuProcessBase *, char *, int);
    
  public slots:
    void restart();
    

  private:
    //enum State {NotRunning, StartingUp, Launching, Running, ShuttingDown};
    enum OutputType {TypeStdout, TypeStderr};
    
    class Private;
    Private *d;
    
    void prepareStart();
    void handleOutput(OutputType type, char *buffer, int buflen);
    
  private slots:
    void slotWroteStdin(KProcess *);
    void slotReceivedStdout(KProcess *, char *, int);
    void slotReceivedStderr(KProcess *, char *, int);
    void slotProcessExited(KProcess *);
};

#endif
