/***************************************************************************
 *   Copyright (C) 2004 by Stefano                                         *
 *   stefano@xiaprojects.com                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef XEMATRIX_H
#define XEMATRIX_H

#include <qobject.h>

#include <stdlib.h>


/**
@author Stefano
*/
class XEMatrix : public QObject
{
Q_OBJECT
public:
    XEMatrix(QObject *parent = 0, const char *name = 0);
    void xMakeCenter(int iconIndex, QPoint *xy);
    void xMakeSpace(int iconIndex, QPoint *xy);

    ~XEMatrix();
    void xMakeBarSpace(int,QPoint *);
signals:
    void xWarningMsg(const QObject *, const QString &);

public slots:
    void xSetup();
    void xCfgChanged(QObject *newConf);
protected:
    void xMake(const QString &);
    class XSConfigurations * 	ActiveConfiguration;
    class XGDocker		*xGDocker;

protected:
    void xMakeRealOSX();
};

#endif
