/***************************************************************************
 *   Copyright (C) 2004 by Stefano                                         *
 *   stefano@xiaprojects.com                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef XEPLUGIN_COMMAND_H
#define XEPLUGIN_COMMAND_H


#include <qobject.h>
#include <qtimer.h>
#include <qevent.h>


#include <kapplication.h>
//#include <qpopupmenu.h>






/**
@author Stefano
*/
class XEPlugin_Command : public QObject
{
Q_OBJECT
public:
    XEPlugin_Command(QObject *parent = 0, const char *name = 0);

    ~XEPlugin_Command();
    void xGetParameter(const QString,QString&);
protected:
	class XSConfigurations *ActiveConfiguration;
	class XGDocker	*xGDocker;
	//class KPopupMenu	*PopMenu;
	QString lastIconExec;
	class XSCfgTasks *lastProcess;
	class XSGObjectIcon *lastIcon;

public slots:
    void xEventMouseClick(int,int,int,int);
    void xSetup();
    void xStop();
    void xStart();
    void xEventMouseWheel(int,int,int,int);
    void RunLastCmd();
    void closeAll();
    void maximizeAll();
    void minimizeAll();
    void KeepInDock();
    void xGetParameterList(QStringList*);
    void activated(int);
protected:
    void popMenu(class XSCfgTasks *);
    void clickMiddle(int iconIndex);
};

#endif
