/***************************************************************************
 *   Copyright (C) 2004 by Stefano                                         *
 *   stefano@xiaprojects.com                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include <xeplugin_taskmanager.h>

#include "xeconfiguration.h"
#include "xgdocker.h"
#include "xgicon.h"

#include <kpopupmenu.h>
#include <kapplication.h>
#include <dcopobject.h>
#include <dcopclient.h>
#include <dcopref.h>


#include <qpixmap.h>
#include <qimage.h>
#include <qregexp.h> 
#include <netwm.h>
#include <stdlib.h>

#include <xeplugin_animator.h>

#include <kxdocker_setup_sources.h>

//#undef ENABLE_FINAL

XEPlugin_TaskManager::XEPlugin_TaskManager(QObject *parent, const char *name)
 : QObject(parent, name)
{
	KDEWM=new KWinModule();
	KDETaskManager=new TaskManager();

	connect( KDEWM,SIGNAL(currentDesktopChanged(int)), this,SLOT(currentDesktopChanged(int)) );
	// Setup of the Task Manager Callbacks
	connect(KDETaskManager, SIGNAL(taskAdded(Task*)), this, SLOT(taskAdded(Task*)) );
	connect(KDETaskManager, SIGNAL(taskRemoved(Task*)), this, SLOT(taskRemoved(Task*)) );
	connect(KDETaskManager, SIGNAL(startupAdded(Startup*)), this, SLOT(startupAdded(Startup*)) );
	connect(KDETaskManager, SIGNAL(startupRemoved(Startup*)), this, SLOT(startupRemoved(Startup*)) );
	connect(KDETaskManager, SIGNAL(taskActivated(Task*)), this, SLOT(taskActivated(Task*)) );
	XEObject::xPluginAdd(this);
//	LastThumbnailUpdate=NULL;
	//0.29
	// dcop
	dcopPollingTimeout=10;
	//dcopClient = kapp->dcopClient();
	dcopClient =new DCOPClient();
	dcopClient->attach();
  connect
    (
     dcopClient,
     SIGNAL(applicationRegistered(const QCString &)),
     SLOT(dcop_applicationRegistered(const QCString &))
    );

  connect
    (
     dcopClient,
     SIGNAL(applicationRemoved(const QCString &)),
     SLOT(dcop_applicationRemoved(const QCString &))
    );

	dcopClient->setNotifications(true);

}


XEPlugin_TaskManager::~XEPlugin_TaskManager()
{
}


#include "xeplugin_taskmanager.moc"


/*!
    \fn XEPlugin_TaskManager::xSetup()
 */
void XEPlugin_TaskManager::xSetup()
{
	showWindowsOnlyFromThisDesktop=0;
	showGroupWindows=0;
	thumbnailShowIcon=1;
	autoAddSeparator=0;
#ifndef ENABLE_FINAL
	qWarning("TaskManager::xSetup()");
#endif
	XEConfiguration *Configurator=(XEConfiguration *)XEObject::xGetConfiguration();
	xGDocker=(XGDocker *)XEObject::xGetDocker();
	if(Configurator==NULL || xGDocker==NULL)
	{
#ifndef ENABLE_FINAL
	// Emits Signal of warning
	//xWarningMsg(this,"error while searching for plugin");
	qWarning("error while searching for plugin");
#endif
		return;
	}
	ActiveConfiguration=Configurator->xGetConfiguration();
	
	// Loading XML Configuration
#ifndef ENABLE_FINAL
	qWarning("xeplugin_taskmanager.cpp 81");
#endif
	for(uint i=0;i<ActiveConfiguration->Plugins.Plugin.count(); i++)
	{
#ifndef ENABLE_FINAL
		qWarning(ActiveConfiguration->Plugins.Plugin.at(i)->Info.Name);
#endif
		if(ActiveConfiguration->Plugins.Plugin.at(i)->Info.Name=="xTaskManager")
		{
		
			if(ActiveConfiguration->Plugins.Plugin.at(i)->xmlConfiguration.count())
		{
#ifndef ENABLE_FINAL
			qWarning("xeplugin_taskmanager.cpp 89");
			qWarning(
ActiveConfiguration->Plugins.Plugin.at(i)->xmlConfiguration.item(0).toElement().attribute("showWindowsOnlyFromThisDesktop")
			);
			
#endif
			
			xSetupParameter("showWindowsOnlyFromThisDesktop",
			ActiveConfiguration->Plugins.Plugin.at(i)->xmlConfiguration.item(0).toElement().attribute("showWindowsOnlyFromThisDesktop")
			);
			xSetupParameter("showGroupWindows",
ActiveConfiguration->Plugins.Plugin.at(i)->xmlConfiguration.item(0).toElement().attribute("showGroupWindows")
			);
			xSetupParameter("autoAddSeparator",
ActiveConfiguration->Plugins.Plugin.at(i)->xmlConfiguration.item(0).toElement().attribute("autoAddSeparator")
			);
			xSetupParameter("thumbnailShowIcon",
ActiveConfiguration->Plugins.Plugin.at(i)->xmlConfiguration.item(0).toElement().attribute("thumbnailShowIcon")
			);
			
			
			
			// Only 1 configuration
		}
		else
		{
#ifndef ENABLE_FINAL
			qWarning("xeplugin_taskmanager.cpp 100");
#endif
			// Ok, You don't have specified the xml configuration, we have to create it!!
			
			// Creating fake document
			QDomDocument 	doc( "KXDocker_Conf" );
			// the fake root
			QDomElement fakeRoot=doc.createElement("FakeRoot");
			// appending childs
			doc.appendChild(fakeRoot);
			// now creating the configuration
			QDomElement CreatingCfg=doc.createElement("pluginconf");
			// Ok this is a plugin Configuration
			QStringList	a;
			// Creating the Attributes via the standard plugin interface
			xGetParameterList(&a);
			for(uint istoringXML=0;istoringXML<a.count();istoringXML++)
			{
				QString returnValue;
				xGetParameter(a[istoringXML],returnValue);
				CreatingCfg.setAttribute(a[istoringXML],returnValue);
			}
			// Now appending to the configuration
			fakeRoot.appendChild(CreatingCfg);
			ActiveConfiguration->Plugins.Plugin.at(i)->xmlConfiguration=fakeRoot.childNodes();//fakeRoot.elementsByTagName("pluginconf");
		}
			break;
		}
	}
}


/*!
    \fn XEPlugin_TaskManager::xStart()
 */
void XEPlugin_TaskManager::xStart()
{
    /// @todo implement me
#ifndef ENABLE_FINAL
    qWarning("TaskManager::xStart()");
#endif
    connect(this,SIGNAL(xEventTaskAppend(int )),xGDocker,SLOT(xEventTaskAppend(int )));
    //connect(this,SIGNAL(xEventTaskAppend(int )),xGDocker,SLOT(xEventTaskAppend(int )));
    
    TaskList taskList = KDETaskManager->tasks();
    Task* task;
    for (task = taskList.first(); task; task = taskList.next())
    {
    	taskAdded(task);
    }
    
    dcopPolling();
}


/*!
    \fn XEPlugin_TaskManager::xStop()
 */
void XEPlugin_TaskManager::xStop()
{
    /// @todo implement me
#ifndef ENABLE_FINAL
    qWarning("TaskManager::xStop()");
#endif
}


/*!
    \fn XEPlugin_TaskManager::currentDesktopChanged(int desktop)
 */
void XEPlugin_TaskManager::currentDesktopChanged(int desktop)
{
#ifndef ENABLE_FINAL
	qWarning("TaskManager::DesktopChanged()");
#endif
	if(showWindowsOnlyFromThisDesktop)
	{
		// we have to remove the other window
		for(uint i =0; i<ActiveConfiguration->ObjectsIcons.count();i++)
		{
			// removing
			usleep(ActiveConfiguration->Engine.SleepThreads);
			if(ActiveConfiguration->ObjectsIcons.at(i)->Info.className!=name())continue;
			int isHere=0;
			for(uint k=0;k<ActiveConfiguration->ObjectsIcons.at(i)->Tasks.Proces.count();k++)
			{
				Task *t=(Task *)ActiveConfiguration->ObjectsIcons.at(i)->Tasks.Proces.at(k);
				if(t->desktop()==desktop)
				{
					isHere=1;
				}
			}
			if(isHere==0)
			{
#ifndef ENABLE_FINAL
				qWarning("Will be removed!");
				qWarning(ActiveConfiguration->ObjectsIcons.at(i)->Info.Name);
#endif
				xGDocker->iconRemove(i,1);
				i--;
	// if auto add separator we check if latest is a separator, we remove it
			}
		}
		
	if(autoAddSeparator)
	{
		QString cn=ActiveConfiguration->ObjectsIcons.at(ActiveConfiguration->ObjectsIcons.count()-1)->Info.className;
		if(cn=="GSeparator")
			xGDocker->iconRemove(ActiveConfiguration->ObjectsIcons.count()-1,1);
	}
		for(uint i =0; i<ActiveConfiguration->RollingIcons.count();i++)
		{
			// adding
			usleep(ActiveConfiguration->Engine.SleepThreads);
			for(uint k=0;k<ActiveConfiguration->RollingIcons.at(i)->Tasks.Proces.count();k++)
			{
				Task *t=(Task *)ActiveConfiguration->RollingIcons.at(i)->Tasks.Proces.at(k);
				if(t->desktop()==desktop)
				{
			int idx=ActiveConfiguration->ObjectsIcons.find(ActiveConfiguration->RollingIcons.at(i));
					if(idx<0)
					{
#ifndef ENABLE_FINAL
						qWarning("Will be showed:");
						qWarning(t->name());
#endif
	if(ActiveConfiguration->ObjectsIcons.count()>=(uint)ActiveConfiguration->Engine.MaxIconsShowed)return;
	if(autoAddSeparator)
	{
		QString cn=ActiveConfiguration->ObjectsIcons.at(ActiveConfiguration->ObjectsIcons.count()-1)->Info.className;
		if(cn!=name() && cn!="GSeparator")
			xGDocker->iconAddSeparator();
	}


			ActiveConfiguration->ObjectsIcons.append(ActiveConfiguration->RollingIcons.at(i));
			xEventTaskAppend(ActiveConfiguration->ObjectsIcons.count()-1);
						
					}
					else
					{
#ifndef ENABLE_FINAL
						qWarning("Already showed");
#endif
					}
				}
			}
		}
	}
}



/*!
    \fn XEPlugin_TaskManager::taskAdded(Task*)
 */
void XEPlugin_TaskManager::taskAdded(Task *t)
{
#ifndef ENABLE_FINAL
	qWarning("TaskManager::taskAdded()");
#endif
	
	QString TaskName=t->className();
	QString WindowTitle=t->name();
	QString ClassName=t->classClass();
	
#ifndef ENABLE_FINAL
	qWarning(TaskName);
	qWarning(WindowTitle);
	qWarning(ClassName);
	qWarning("Test == TITLE");
#endif
	// new patch for kxdocker-0.19 20040524
	// grouped windows!
	if(showGroupWindows)
	{
		//qWarning("showGroupWindows!=0 we will group windows");
	// checking for window title ==
	//for(uint i =0; i<ActiveConfiguration->ObjectsIcons.count();i++)
	//0.29


if(WindowTitle!=""){
	for(uint i =0; i<ActiveConfiguration->RollingIcons.count();i++)
	{
		// (martind@pirack.com) Avoid null pointer when (e.g.) opening the configuration dialog for screensaver
		if (ActiveConfiguration->RollingIcons.at(i) != NULL)
		{
		  usleep(ActiveConfiguration->Engine.SleepThreads);
		  for(uint k=0;k<ActiveConfiguration->RollingIcons.at(i)->Tasks.WindowTitle.count();k++)
		  {
#ifndef ENABLE_FINAL
		    qWarning(ActiveConfiguration->RollingIcons.at(i)->Tasks.WindowTitle[k]);
#endif
			if(ActiveConfiguration->RollingIcons.at(i)->Tasks.WindowTitle[k]=="")continue;
			  if(ActiveConfiguration->RollingIcons.at(i)->Tasks.WindowTitle[k]==WindowTitle)
			  {
				  ActiveConfiguration->RollingIcons.at(i)->Tasks.Proces.append(t);
				  ActiveConfiguration->RollingIcons.at(i)->Tasks.TaskInfo=(void *)t;
				  gotTaskInCache(ActiveConfiguration->RollingIcons.at(i));
				  return;
			  }
		  }
		}
	}
#ifndef ENABLE_FINAL
	qWarning("Test find Title ");
#endif
	for(uint i =0; i<ActiveConfiguration->RollingIcons.count();i++)
	{
		usleep(ActiveConfiguration->Engine.SleepThreads);
		for(uint k=0;k<ActiveConfiguration->RollingIcons.at(i)->Tasks.WindowTitle.count();k++)
		{
			QString pippo=ActiveConfiguration->RollingIcons.at(i)->Tasks.WindowTitle[k];
			if(pippo=="")continue;
			if(WindowTitle.startsWith(pippo,false))
			{
#ifndef ENABLE_FINAL
				qWarning("String OK");
				qWarning(pippo);
#endif
				ActiveConfiguration->RollingIcons.at(i)->Tasks.Proces.append(t);
				ActiveConfiguration->RollingIcons.at(i)->Tasks.TaskInfo=(void *)t;
				gotTaskInCache(ActiveConfiguration->RollingIcons.at(i));
				return;
			}
			if(WindowTitle.endsWith(pippo,false))
			{
#ifndef ENABLE_FINAL
				qWarning("String OK");
				qWarning(pippo);
#endif
				ActiveConfiguration->RollingIcons.at(i)->Tasks.Proces.append(t);
				ActiveConfiguration->RollingIcons.at(i)->Tasks.TaskInfo=(void *)t;
				gotTaskInCache(ActiveConfiguration->RollingIcons.at(i));
				return;
			}
		}
	}
}
#ifndef ENABLE_FINAL
	qWarning("Test == Taskname");
#endif
if(TaskName!="")
{
		for(uint i =0; i<ActiveConfiguration->RollingIcons.count();i++)
		{
			usleep(ActiveConfiguration->Engine.SleepThreads);
			for(uint k=0;k<ActiveConfiguration->RollingIcons.at(i)->Tasks.TaskName.count();k++)
			{
			if(ActiveConfiguration->RollingIcons.at(i)->Tasks.TaskName[k]=="")continue;

				if(ActiveConfiguration->RollingIcons.at(i)->Tasks.TaskName[k]==TaskName)
				{
					ActiveConfiguration->RollingIcons.at(i)->Tasks.Proces.append(t);
					ActiveConfiguration->RollingIcons.at(i)->Tasks.TaskInfo=(void *)t;
					gotTaskInCache(ActiveConfiguration->RollingIcons.at(i));
					return;
				}
			}
		}
}
	#ifndef ENABLE_FINAL
		qWarning("Test == Class");
	#endif
if(ClassName!="")
{
		for(uint i =0; i<ActiveConfiguration->RollingIcons.count();i++)
		{
			usleep(ActiveConfiguration->Engine.SleepThreads);
			for(uint k=0;k<ActiveConfiguration->RollingIcons.at(i)->Tasks.ClassName.count();k++)
			{

				if(ActiveConfiguration->RollingIcons.at(i)->Tasks.ClassName[k]=="")continue;

				if(ActiveConfiguration->RollingIcons.at(i)->Tasks.ClassName[k]==ClassName)
				{
					ActiveConfiguration->RollingIcons.at(i)->Tasks.Proces.append(t);
					ActiveConfiguration->RollingIcons.at(i)->Tasks.TaskInfo=(void *)t;
					gotTaskInCache(ActiveConfiguration->RollingIcons.at(i));
					return;
				}
			}
		}
	}
}
	// ok, we havent find it...
	// making new configuration
	if(ActiveConfiguration->ObjectsIcons.count()>=(uint)ActiveConfiguration->Engine.MaxIconsShowed)return;
	
	// 0.35
	//XSGObjectIcon *addedCfg=new XSGObjectIcon;
	XEConfiguration *xEConfiguration=(XEConfiguration *)XEObject::xGetConfiguration();
	if(xEConfiguration==NULL)qWarning(name());
	XSGObjectIcon *addedCfg=xEConfiguration->iconAdd();



//	addedCfg->Tasks.PopupMenu=new KPopupMenu();
	addedCfg->Tasks.PopupMenu=NULL;
	addedCfg->PluginPopupMenu=NULL;

	// New engine with disabled windows!
	// I will add the icon at the end if the class is not disabled!
	//ActiveConfiguration->RollingIcons.append(addedCfg);
	
	addedCfg->Tasks.Proces.clear();
	
	
	addedCfg->Info.fileName=TaskName;
	addedCfg->Info.Name=TaskName;
	addedCfg->Info.Group=TaskName;
	addedCfg->Actions.onClickExec=TaskName;
	addedCfg->Actions.onDropExec=TaskName;
	addedCfg->Actions.onDropExec+=" \"%1\"";
	
	addedCfg->OverText=TaskName;
	addedCfg->Images.imgFileName=TaskName;
	addedCfg->Tasks.WindowTitle.append(WindowTitle);
	addedCfg->Tasks.TaskName.append(TaskName);
	addedCfg->Tasks.ClassName.append(ClassName);
	addedCfg->Tasks.ShowThumbnail=0;
	addedCfg->Tasks.Thumbnail=t->thumbnail();
	addedCfg->Tasks.TaskInfo=(void *)t;
	addedCfg->Tasks.Proces.append(t);
	//0.29
	addedCfg->Tasks.dcopName.append(TaskName);
	// TODO better dcop notification support
	addedCfg->Tasks.dcopReady=0;
	addedCfg->Tasks.forceRunning=0;
	addedCfg->Tasks.dcopNewWindow="dcop "+TaskName+" "+TaskName+"-mainwindow#1 restore";
	addedCfg->Tasks.dcopClose="dcop "+TaskName+" "+TaskName+"-mainwindow#1 close";
	addedCfg->Tasks.dcopRestore="dcop "+TaskName+" "+TaskName+"-mainwindow#1 restore";
	
	
	// new engine 0.13 match on custom entry
#ifndef ENABLE_FINAL
	qWarning("Test == TITLE (custom entry)");
#endif
	for(uint i=0; i<ActiveConfiguration->Plugins.Matches.count();i++)
	{
		usleep(ActiveConfiguration->Engine.SleepThreads);
		for(uint k=0;k<ActiveConfiguration->Plugins.Matches.at(i)->Icon->Tasks.WindowTitle.count();k++)
		{
#ifndef ENABLE_FINAL
			qWarning(ActiveConfiguration->Plugins.Matches.at(i)->Icon->Tasks.WindowTitle[k]);
#endif
			
			if(ActiveConfiguration->Plugins.Matches.at(i)->Icon->Tasks.WindowTitle[k]==WindowTitle)
			{
				// Got it
#ifndef ENABLE_FINAL
				qWarning("match!");
#endif
				clonate(addedCfg,ActiveConfiguration->Plugins.Matches.at(i)->Icon);
				//return;
				break;
			}
		}
	}
	
	for(uint i=0; i<ActiveConfiguration->Plugins.Matches.count();i++)
	{
		usleep(ActiveConfiguration->Engine.SleepThreads);
		for(uint k=0;k<ActiveConfiguration->Plugins.Matches.at(i)->Icon->Tasks.WindowTitle.count();k++)
		{
#ifndef ENABLE_FINAL
			qWarning(ActiveConfiguration->Plugins.Matches.at(i)->Icon->Tasks.WindowTitle[k]);
#endif
			if(ActiveConfiguration->Plugins.Matches.at(i)->Icon->Tasks.WindowTitle[k]=="")continue;
			if(WindowTitle.startsWith(
				ActiveConfiguration->Plugins.Matches.at(i)->Icon->Tasks.WindowTitle[k])
			)
			{
				// Got it
#ifndef ENABLE_FINAL
				qWarning("match!");
#endif
				clonate(addedCfg,ActiveConfiguration->Plugins.Matches.at(i)->Icon);
				//return;
				break;
			}
			if(WindowTitle.endsWith(
				ActiveConfiguration->Plugins.Matches.at(i)->Icon->Tasks.WindowTitle[k])
			)
			{
				// Got it
#ifndef ENABLE_FINAL
				qWarning("match!");
#endif
				clonate(addedCfg,ActiveConfiguration->Plugins.Matches.at(i)->Icon);
				//return;
				break;
			}
		}
	}
	
	// New engine 20040509
	if(addedCfg->Info.className=="disabled")
	{
		// We don't like it!!!
		// it will not be showed
		
		// clean up memory
		// TODO: Garmbage on PopupMenu or KPopupmenu ?
		// TODO: right cleanup of icons removed
		if(addedCfg->Tasks.PopupMenu)delete addedCfg->Tasks.PopupMenu;
		delete addedCfg;
		return;
	}
	// We have to restore the class
	// because the icons added MUST be managed by task manager :)
	addedCfg->Info.className=name();
	
	connect(t,SIGNAL(thumbnailChanged(Task *)),this,SLOT(thumbnailChanged(Task *)));
	
	
	ActiveConfiguration->RollingIcons.append(addedCfg);
	
	if(showWindowsOnlyFromThisDesktop==0 || t->desktop()==KDEWM->currentDesktop())
	{
	if(autoAddSeparator)
	{
		QString cn=ActiveConfiguration->ObjectsIcons.at(ActiveConfiguration->ObjectsIcons.count()-1)->Info.className;
		if(cn!=name() && cn!="GSeparator")
			xGDocker->iconAddSeparator();
	}
		ActiveConfiguration->ObjectsIcons.append(addedCfg);
		xEventTaskAppend(ActiveConfiguration->ObjectsIcons.count()-1);
		// Ok than icon is added, we will set the image
		// 31052004
		QImage defaulImage=ActiveConfiguration->Theme.DefaultIcon.convertToImage();
		XGIcon *newIcon=xGDocker->getObjectIcon(ActiveConfiguration->ObjectsIcons.count()-1);
		if(newIcon->xImgSource==defaulImage)
		{
//			qWarning("You don't have configured the right PNG for this window I will generate new one.");
			//bool isStaticIcon;
			newIcon->xImgSource=t->pixmap();
			newIcon->xImgOriginal=newIcon->xImgSource;
			newIcon->cachePurge();
			int z=newIcon->xZoom;
			newIcon->xZoom=0;
			newIcon->xSetSmoothZoom(z);
			//t->bestIcon(ActiveConfiguration->Icons.SizeBig,isStaticIcon).convertToImage();
		}
	}
	
	if(ActiveConfiguration->Icons.EnableThumbnail)
	{
		// 0.32
		t->setThumbnailSize(ActiveConfiguration->Icons.SizeBig);
		//t->setThumbnailSize(128);
		t->updateThumbnail(2000);
	}
}


/*!
    \fn XEPlugin_TaskManager::taskRemoved(Task*)
 */
void XEPlugin_TaskManager::taskRemoved(Task*t)
{
    /// @todo implement me
#ifndef ENABLE_FINAL
    qWarning("TaskManager::taskRemoved()");
    qWarning(t->className());
#endif
    removeIcon(t);
}


/*!
    \fn XEPlugin_TaskManager::startupAdded(Startup*)
 */
void XEPlugin_TaskManager::startupAdded(Startup* newApp)
{
    /// @todo implement me
#ifndef ENABLE_FINAL
    qWarning("TaskManager::StartupAdd()");
#endif

	QString iname=newApp->text();
	XEPlugin_Animator *xAnimator=(XEPlugin_Animator *)XEObject::xFindObject("xAnimator");
	if(!xAnimator)return;
	for(uint i=0;i<ActiveConfiguration->ObjectsIcons.count();i++)
	{
		if(ActiveConfiguration->ObjectsIcons.at(i)->Info.Name==iname)
		{
			XGIcon *theIcon=xGDocker->getObjectIcon(i);
			if(!theIcon)return;
			xAnimator->xStartAnimate(theIcon);
			return;
		}
	}
}


/*!
    \fn XEPlugin_TaskManager::startupRemoved(Startup*)
 */
void XEPlugin_TaskManager::startupRemoved(Startup* newApp)
{
    /// @todo implement me
#ifndef ENABLE_FINAL
    qWarning("TaskManager::StartupRemoved()");
#endif

	QString iname=newApp->text();
	XEPlugin_Animator *xAnimator=(XEPlugin_Animator *)XEObject::xFindObject("xAnimator");
	if(!xAnimator)return;

	xAnimator->xStopAnimate();

}


/*!
    \fn XEPlugin_TaskManager::removeIcon(int)
 */
void XEPlugin_TaskManager::removeIcon(Task *t)
{
#ifndef ENABLE_FINAL
qWarning("taskmanager polling");
#endif
    for(uint i=0;i<ActiveConfiguration->RollingIcons.count();i++)
    {
#ifndef ENABLE_FINAL
qWarning("xeplugin_taskmanger.cpp:347");
#endif
    	if(ActiveConfiguration->RollingIcons.at(i)->Tasks.Proces.find(t)>=0)
	{
#ifndef ENABLE_FINAL
qWarning("xeplugin_taskmanger.cpp:350");
#endif
		if(ActiveConfiguration->RollingIcons.at(i)->Tasks.Proces.count()>1)
		{
				ActiveConfiguration->RollingIcons.at(i)->Tasks.Proces.remove(t);
				ActiveConfiguration->RollingIcons.at(i)->Tasks.TaskInfo=
					ActiveConfiguration->RollingIcons.at(i)->Tasks.Proces.at(0);
				return;
		}
		else
		{
			// we can remove it
#ifndef ENABLE_FINAL
			qWarning("Last window is closed");
#endif
		    	if(ActiveConfiguration->RollingIcons.at(i)->Info.className!=name())
			{
#ifndef ENABLE_FINAL
			qWarning("Not managed by taskmanager");
#endif
				ActiveConfiguration->RollingIcons.at(i)->Tasks.Proces.clear();
				ActiveConfiguration->RollingIcons.at(i)->Tasks.TaskInfo=NULL;
				xGDocker->xUpdate();
				xGDocker->update();
			int idx=ActiveConfiguration->ObjectsIcons.find(ActiveConfiguration->RollingIcons.at(i));
				if(idx>=0)
				{
					xEventRemoveIcon(idx);
					xGDocker->xUpdate();
					xGDocker->repaint(false);
				}
				return;
			}
#ifndef ENABLE_FINAL
			qWarning("Managed by taskmanager");
#endif
			// patch 20040421
			// since we have added the icon to Rollling icons
			// TODO:have to remove manually the icon frfrom rolling icons list
			int idx=ActiveConfiguration->ObjectsIcons.find(ActiveConfiguration->RollingIcons.at(i));
			ActiveConfiguration->RollingIcons.remove(i);
			if(idx>=0)
			{
#ifndef ENABLE_FINAL
			qWarning("removing");
#endif

			xGDocker->iconRemove(idx);
			
	if(autoAddSeparator)
	{
		QString cn=ActiveConfiguration->ObjectsIcons.at(ActiveConfiguration->ObjectsIcons.count()-1)->Info.className;
		if(cn=="GSeparator")
			xGDocker->iconRemove(ActiveConfiguration->ObjectsIcons.count()-1,1);
	}
			xGDocker->xUpdate();
			xGDocker->repaint(false);
			return;
			}
		}
	}
    }
}


/*!
    \fn XEPlugin_TaskManager::thumbnailChanged()
 */
void XEPlugin_TaskManager::thumbnailChanged(Task *t)
{
#ifndef ENABLE_FINAL
	qWarning("Thumbnail preview");
#endif
	if(t==NULL)return;

    for(uint i=0;i<ActiveConfiguration->ObjectsIcons.count();i++)
    {
	if(ActiveConfiguration->ObjectsIcons.at(i)->Tasks.Proces.find(t)>=0)
	{
		QImage TBuffer;
		TBuffer.create(
			ActiveConfiguration->Icons.SizeBig,
			ActiveConfiguration->Icons.SizeBig,
			32);
		
		TBuffer.setAlphaBuffer(false);
		//TBuffer.fill(QColor(255,0,0).pixel());
		TBuffer.fill(0);
		TBuffer.setAlphaBuffer(true);
		
		
		ActiveConfiguration->ObjectsIcons.at(i)->Tasks.Thumbnail=t->thumbnail().convertToImage();
		ActiveConfiguration->ObjectsIcons.at(i)->Tasks.Thumbnail=
			ActiveConfiguration->ObjectsIcons.at(i)->Tasks.Thumbnail
			.smoothScale(
			ActiveConfiguration->Icons.SizeBig,
			ActiveConfiguration->Icons.SizeBig,QImage::ScaleMin);
		
		bitBlt(&TBuffer,
			(ActiveConfiguration->Icons.SizeBig-
			ActiveConfiguration->ObjectsIcons.at(i)->Tasks.Thumbnail.width())/2
			,
			(ActiveConfiguration->Icons.SizeBig-
			ActiveConfiguration->ObjectsIcons.at(i)->Tasks.Thumbnail.height())/2
			,
			&ActiveConfiguration->ObjectsIcons.at(i)->Tasks.Thumbnail,0,Qt::CopyROP);
		
		if(thumbnailShowIcon)
		{
		QImage MiniIco=xGDocker->getObjectIcon(i)->xImgOriginal.smoothScale(
			ActiveConfiguration->Icons.SizeBig-
			ActiveConfiguration->Icons.Size,
			ActiveConfiguration->Icons.SizeBig-
			ActiveConfiguration->Icons.Size,QImage::ScaleMin);
		
		bitBlt(&TBuffer,
			ActiveConfiguration->Icons.Size,
			ActiveConfiguration->Icons.Size,
			&MiniIco,0,Qt::CopyROP);
		}	
		ActiveConfiguration->ObjectsIcons.at(i)->Tasks.Thumbnail=TBuffer;
		
		xGDocker->getObjectIcon(i)->xImgSource=ActiveConfiguration->ObjectsIcons.at(i)->Tasks.Thumbnail;
		
		xGDocker->getObjectIcon(i)->cachePurge();
		xGDocker->getObjectIcon(i)->xSetSmoothZoom(xGDocker->getObjectIcon(i)->xZoom);
		xGDocker->getObjectIcon(i)->xSetUpdate=1;
		xGDocker->xUpdate();
		xGDocker->repaint(false);
		return;
	}
    }
}




/*!
    \fn XEPlugin_TaskManager::taskActivated(Task*)
 */
void XEPlugin_TaskManager::taskActivated(Task*t)
{
	taskActivatedMultipass(t);
	// 0.21 check out if a name or icon may be changed
	taskActivatedCheckTitle(t);
}


/*!
    \fn XEPlugin_TaskManager::clonate(XSGObjectIcon *,XSGObjectIcon *)
 */
void XEPlugin_TaskManager::clonate(XSGObjectIcon *dst,XSGObjectIcon *src)
{
	// New engine!!!
	// 20040509 class may be disabled!!!
	dst->Info.className=src->Info.className;
	dst->Info.fileName=src->Info.fileName;
	dst->Info.Name=src->Info.Name;
	dst->Info.Group=src->Info.Group;
	dst->Actions.onClickExec=src->Actions.onClickExec;
	dst->Actions.onDropExec=src->Actions.onDropExec;
	dst->OverText=src->OverText;
	dst->Images.imgFileName=src->Images.imgFileName;

}


/*!
    \fn XEPlugin_TaskManager::xSetupParameter(QString sName, QString sValue)
 */
void XEPlugin_TaskManager::xSetupParameter(const QString sName,const  QString sValue)
{
	bool okRet=false;
#ifndef ENABLE_FINAL
	qWarning(sName);
	qWarning(sValue);
#endif
	if(sName=="showWindowsOnlyFromThisDesktop")
	{
		showWindowsOnlyFromThisDesktop=sValue.toInt(&okRet);
		if(okRet==false)
		{
			showWindowsOnlyFromThisDesktop=0;
		}
		updateXMLcfg(sName);
	}
	
	if(sName=="showGroupWindows")
	{
		showGroupWindows=sValue.toInt(&okRet);
		if(okRet==false)
		{
			showGroupWindows=0;
		}
				updateXMLcfg(sName);

	}
	if(sName=="thumbnailShowIcon")
	{
		thumbnailShowIcon=sValue.toInt(&okRet);
		if(okRet==false)
		{
			thumbnailShowIcon=0;
		}
				updateXMLcfg(sName);

	}
	
	if(sName=="autoAddSeparator")
	{
		autoAddSeparator=sValue.toInt(&okRet);
		if(okRet==false)
		{
			autoAddSeparator=0;
		}
		updateXMLcfg(sName);

	}

}


/*!
    \fn XEPlugin_TaskManager::xSetupParameter(QString sName, int iValue)
 */
void XEPlugin_TaskManager::xSetupParameter(const QString sName, int iValue)
{
	if(sName=="showWindowsOnlyFromThisDesktop")
	{
		showWindowsOnlyFromThisDesktop=iValue;
		updateXMLcfg(sName);
	}
	if(sName=="showGroupWindows")
	{
		showGroupWindows=iValue;
		updateXMLcfg(sName);
	}
	if(sName=="thumbnailShowIcon")
	{
		thumbnailShowIcon=iValue;
		updateXMLcfg(sName);
	}
	
	if(sName=="autoAddSeparator")
	{
		autoAddSeparator=iValue;
		updateXMLcfg(sName);
	}
	
	
}


/*!
    \fn XEPlugin_TaskManager::xGetParameter(QString sName, QString sValue)
 */
void XEPlugin_TaskManager::xGetParameter(const QString sName, QString &sValue)
{
#ifndef ENABLE_FINAL
	qWarning(sName);
#endif
	if(sName=="showWindowsOnlyFromThisDesktop")
	{
		sValue.setNum(showWindowsOnlyFromThisDesktop);
	}
	if(sName=="showGroupWindows")
	{
		sValue.setNum(showGroupWindows);
	}
	if(sName=="autoAddSeparator")
	{
		sValue.setNum(autoAddSeparator);
	}
	if(sName=="thumbnailShowIcon")
	{
		sValue.setNum(thumbnailShowIcon);
	}
	
}


/*!
    \fn XEPlugin_TaskManager::xGetParameter(QString sName, int iValue)
 */
void XEPlugin_TaskManager::xGetParameter(QString sName, int &iValue)
{
	if(sName=="showWindowsOnlyFromThisDesktop")
	{
		iValue=showWindowsOnlyFromThisDesktop;
	}
	if(sName=="showGroupWindows")
	{
		iValue=showGroupWindows;
	}
	if(sName=="thumbnailShowIcon")
	{
		iValue=thumbnailShowIcon;
	}
	
	
	
}


/*!
    \fn XEPlugin_TaskManager::gotTaskInCache(xxxxx)
 */
void XEPlugin_TaskManager::gotTaskInCache(XSGObjectIcon *icon)
{
#ifndef ENABLE_FINAL

	qWarning("void XEPlugin_TaskManager::gotTaskInCache(XSGObjectIcon *icon)");
#endif
	int idx=ActiveConfiguration->ObjectsIcons.find(icon);
	if(idx>=0)
	{
		xEventTaskOpen(idx);
	}
}


/*!
    \fn XEPlugin_TaskManager::xToggleShowAll()
 */
void XEPlugin_TaskManager::xToggleShowAll()
{
	if(showWindowsOnlyFromThisDesktop)showWindowsOnlyFromThisDesktop=0;
	else showWindowsOnlyFromThisDesktop=1;
}


/*!
    \fn XEPlugin_TaskManager::xGetParameters(QStringList *)
 */
void XEPlugin_TaskManager::xGetParameterList(QStringList *a)
{
	a->append("showWindowsOnlyFromThisDesktop");
	a->append("showGroupWindows");
	a->append("autoAddSeparator");
	a->append("thumbnailShowIcon");
}


/*!
    \fn XEPlugin_TaskManager::updateXMLcfg()
 */
void XEPlugin_TaskManager::updateXMLcfg(const QString sName)
{
	for(uint i=0;i<ActiveConfiguration->Plugins.Plugin.count(); i++)
	{
		if(ActiveConfiguration->Plugins.Plugin.at(i)->Info.Name=="xTaskManager")
		{
		
		// update xml configuration
		if(sName=="autoAddSeparator")
		{
			ActiveConfiguration->Plugins.Plugin.at(i)->xmlConfiguration.item(0).toElement().setAttribute("autoAddSeparator",autoAddSeparator);
		}
		if(sName=="showWindowsOnlyFromThisDesktop")
		{
			ActiveConfiguration->Plugins.Plugin.at(i)->xmlConfiguration.item(0).toElement().setAttribute("showWindowsOnlyFromThisDesktop",showWindowsOnlyFromThisDesktop);
		}
		if(sName=="showGroupWindows")
		{
			ActiveConfiguration->Plugins.Plugin.at(i)->xmlConfiguration.item(0).toElement().setAttribute("showGroupWindows",showGroupWindows);
		}
		if(sName=="thumbnailShowIcon")
		{
			ActiveConfiguration->Plugins.Plugin.at(i)->xmlConfiguration.item(0).toElement().setAttribute("thumbnailShowIcon",thumbnailShowIcon);
		}
		}
	}
}
//#include <xeplugin_gepillow.h>

/*!
    \fn XEPlugin_TaskManager::taskActivatedMultipass(Task *t)
 */
inline void XEPlugin_TaskManager::taskActivatedMultipass(Task *t)
{

	if(xGDocker->getRaised())
	{

/*
	// 0.35 fix for the pillow
	XGIcon *ZeroIcon=xGDocker->getObjectIcon(0);
	if(ZeroIcon!=NULL && ZeroIcon->xPillow!=NULL)
	{
	// hide
		ZeroIcon->xPillow->hide();
	// show it
		ZeroIcon->xPillow->show();
	}
*/



		if(t==NULL)
		{
			// is the desktop
			xGDocker->xBliz(1);
			return;
		}
//		qWarning(t->visibleName());
		if(t->getID()==QApplication::desktop()->winId())
		{
			// is the desktop
			xGDocker->xBliz(1);
			return;
		}
		int sy=t->getGeometry().y();
		int ey=t->getGeometry().y()+t->getGeometry().height();
		if(	(ey>=xGDocker->y() && xGDocker->xGetLayout()==LONBOTTOM)
			||
			(sy<=xGDocker->y()+ActiveConfiguration->Window.Height
				 && xGDocker->xGetLayout()==LONTOP)
			)
		{
			xGDocker->xBliz();
			return;
		}
	}
	else
	{
		if(t==NULL)
		{
			// is the desktop
			return;
		}
		if(ActiveConfiguration->Icons.EnableThumbnail)
		{
		// 0.32
		t->setThumbnailSize(ActiveConfiguration->Icons.SizeBig);
		//t->setThumbnailSize(128);
			t->updateThumbnail(2000);
		}
	}
}


/*!
    \fn XEPlugin_TaskManager::taskActivatedCheckTitle(Task *t);
 */
inline void XEPlugin_TaskManager::taskActivatedCheckTitle(Task *t)
{
	// TODO: use Task->iconChanged signal
	return;
	for(uint i=0;i<ActiveConfiguration->ObjectsIcons.count();i++)
	{
		if(ActiveConfiguration->ObjectsIcons.at(i)->Tasks.Proces.find(t)>=0)
		{
		}
	}
}


/*!
    \fn XEPlugin_TaskManager::dcopPolling()
 */
void XEPlugin_TaskManager::dcopPolling()
{
	// this is the polling for checcking dcop hidden windows
	for(uint i =0; i<ActiveConfiguration->RollingIcons.count();i++)
	{
		// (martind@pirack.com) Avoid null pointer when (e.g.) opening the configuration dialog for screensaver
		if (ActiveConfiguration->RollingIcons.at(i) != NULL)
		{
		  usleep(ActiveConfiguration->Engine.SleepThreads);
		  for(uint k=0;k<ActiveConfiguration->RollingIcons.at(i)->Tasks.dcopName.count();k++)
		  {
		  QCString pippo=QCString(ActiveConfiguration->RollingIcons.at(i)->Tasks.dcopName[k]);
//		  qWarning(QString("%1 is running").arg(pippo));
				if(dcopClient->isApplicationRegistered(pippo)){
				  ActiveConfiguration->RollingIcons.at(i)->Tasks.dcopReady=1;
				  //gotTaskInCache(ActiveConfiguration->RollingIcons.at(i));
				  //return;
			  }
		  }
		}
	}

}


/*!
    \fn XEPlugin_TaskManager::dcop_applicationRemoved(const QCString &)
 */
void XEPlugin_TaskManager::dcop_applicationRemoved(const QCString &dcopNewName)
{
	QString sdcopNewName=QString(dcopNewName);
	if(sdcopNewName=="")return;
//	qWarning(QString("dcop: removing %1").arg(sdcopNewName));

	for(uint i =0; i<ActiveConfiguration->RollingIcons.count();i++)
	{
		// (martind@pirack.com) Avoid null pointer when (e.g.) opening the configuration dialog for screensaver
		if (ActiveConfiguration->RollingIcons.at(i) != NULL)
		{
		  usleep(ActiveConfiguration->Engine.SleepThreads);
		  for(uint k=0;k<ActiveConfiguration->RollingIcons.at(i)->Tasks.dcopName.count();k++)
		  {
			  if(sdcopNewName.startsWith(ActiveConfiguration->RollingIcons.at(i)->Tasks.dcopName[k],false))
			  {
	  		  QCString pippo=QCString(ActiveConfiguration->RollingIcons.at(i)->Tasks.dcopName[k]);
		  	//qWarning(QString("%1 is running").arg(pippo));
			if(dcopClient->isApplicationRegistered(pippo)){
				  ActiveConfiguration->RollingIcons.at(i)->Tasks.dcopReady=1;
			}
			else
			{
				  ActiveConfiguration->RollingIcons.at(i)->Tasks.dcopReady=0;
				  xGDocker->xUpdate();
				  xGDocker->repaint(false);
			}
				  return;
			  }
		  }
		}
	}

}


/*!
    \fn XEPlugin_TaskManager::dcop_applicationRegistered(const QCString &)
 */
void XEPlugin_TaskManager::dcop_applicationRegistered(const QCString &dcopNewName)
{
	QString sdcopNewName=QString(dcopNewName);	
	if(sdcopNewName=="")return;
//	qWarning(QString("dcop: added %1").arg(sdcopNewName));
	for(uint i =0; i<ActiveConfiguration->RollingIcons.count();i++)
	{
		// (martind@pirack.com) Avoid null pointer when (e.g.) opening the configuration dialog for screensaver
		if (ActiveConfiguration->RollingIcons.at(i) != NULL)
		{
		  usleep(ActiveConfiguration->Engine.SleepThreads);
		  for(uint k=0;k<ActiveConfiguration->RollingIcons.at(i)->Tasks.dcopName.count();k++)
		  {
			if(ActiveConfiguration->RollingIcons.at(i)->Tasks.dcopName[k]=="")continue;
			if(sdcopNewName.startsWith(ActiveConfiguration->RollingIcons.at(i)->Tasks.dcopName[k],false))
			  {
				  ActiveConfiguration->RollingIcons.at(i)->Tasks.dcopReady=1;
				  gotTaskInCache(ActiveConfiguration->RollingIcons.at(i));
				  return;
			  }
		  }
		}
	}
}
