/***************************************************************************
 *
 *  $Id: kzennavigationview.cpp,v 1.10 2005/06/04 10:22:21 muszilla Exp $
 *
 *  Copyright (C) 2005 by Andreas Mussgiller
 *  muszilla@users.sourceforge.net
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the
 *  Free Software Foundation, Inc.,
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 ***************************************************************************/

#include <iostream>

#include <qdragobject.h>
#include <qpoint.h>
#include <qheader.h>

#include <kurldrag.h>
#include <kdebug.h>

#include "kzenitem.h"
#include "kzenexplorerview.h"
#include "kzennavigationview.h"

KZenNavigationView::KZenNavigationView(QWidget *parent, const char *name)
  :KListView(parent, name)
{
  setAcceptDrops(true);
  setDropVisualizer(true);

  connect(this, SIGNAL(mouseButtonPressed(int, QListViewItem *, const QPoint &, int)),
	  this, SLOT(mousePressed(int, QListViewItem *, const QPoint &, int)));

  connect(this,SIGNAL(doubleClicked(QListViewItem *, const QPoint &, int)),
	  this,SLOT(itemDoubleClicked(QListViewItem *, const QPoint &, int)));
}

KZenNavigationView::~KZenNavigationView()
{

}

void KZenNavigationView::contentsDragMoveEvent(QDragMoveEvent * event)
{
  if (event->source()==fgTrackSource) {
    //kdDebug() << "contentsDragMoveEvent: fgTrackSource" << endl;
    
    QPoint vp = contentsToViewport(event->pos());
    KZenItem * item = (KZenItem*)itemAt(vp);
    
    if (!item || 
	item->getItemType()!=KZenItem::ItemTypePlayList ||
	item->isSelected()) {
      event->accept(false);
    } else {
      event->accept(QTextDrag::canDecode(event));
    }
  } else if (event->source()!=fgTrackSource && event->source()!=fgNaviSource) {
    //kdDebug() << "contentsDragMoveEvent: !this" << endl;
    event->accept(QTextDrag::canDecode(event));
  } else {
    //kdDebug() << "contentsDragMoveEvent: !accept" << endl;
    event->accept(false);
  }
}

void KZenNavigationView::contentsDropEvent(QDropEvent * event)
{ 
  KZenPlayList * pl = 0;
  QPoint vp = contentsToViewport(event->pos());
  KZenItem * item = (KZenItem*)itemAt(vp);
  if (item && item->getItemType()==KZenItem::ItemTypePlayList) {
    pl = ((KZenPlayListItem*)item)->getPlayList();
  }
  
  if (event->source()==fgTrackSource) {
    //kdDebug() << "contentsDropEvent: fgTrackSource" << endl;

    if (!item || !pl) {
      event->accept(false);
    } else {
      event->accept(decodeTracks(event,pl));
    }
  } else if (event->source()!=fgTrackSource && event->source()!=fgNaviSource) {
    //kdDebug() << "contentsDropEvent: !this" << endl;
    event->accept(decode(event,pl));
  } else {
    //kdDebug() << "contentsDropEvent: !accept" << endl;
    event->accept(false);
  }
}

void KZenNavigationView::itemDoubleClicked(QListViewItem * item, const QPoint &, int)
{
  if (!item) return;

  if (!item->isOpen()) {
    item->setOpen(true);
  } else {
    item->setOpen(false);
  }
}

bool KZenNavigationView::decode(QMimeSource *s, KZenPlayList * PL)
{
  KURL::List urls;
  
  if(!KURLDrag::decode(s, urls) || urls.isEmpty())
    return false;
  
  QStringList fileList;
  
  for(KURL::List::Iterator it = urls.begin(); it != urls.end(); it++) {
    fileList.append((*it).path());
  }
  
  emit filesDropped(fileList, PL);

  return true;
}

bool KZenNavigationView::decodeTracks(QMimeSource *s, KZenPlayList * PL)
{
  QString l;

  if (!QTextDrag::decode(s,l))
    return false;

  QStringList trackList = QStringList::split('\n',l);

  emit tracksDropped(trackList, PL);
  
  return true;
}

void KZenNavigationView::mousePressed(int button, QListViewItem *item, const QPoint &pnt, int)
{
  if (!item || button != LeftButton) return;

  if (KZen::artistItem(item)) {
    QPoint p = mapFromGlobal(pnt);
    QRect itemrect = itemRect(item);
    
    QRect expandRect = QRect(4, itemrect.y() + (item->height()/2) - 5, 15, 15);

    if (expandRect.contains(p)) {
      setOpen(item, !item->isOpen());
    }
  }
}

#include "kzennavigationview.moc"
