/***************************************************************************
 *
 *  $Id: kzentrackview.h,v 1.15 2005/07/03 18:27:52 muszilla Exp $
 *
 *  Copyright (C) 2005 by Andreas Mussgiller
 *  muszilla@users.sourceforge.net
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the
 *  Free Software Foundation, Inc.,
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 ***************************************************************************/

#ifndef KZENTRACKVIEW_H
#define KZENTRACKVIEW_H

#include <qwidget.h>
#include <qvbox.h>

#include <kcombobox.h>
#include <kaction.h>
#include <ktoolbar.h>

#include "kzenglobal.h"
#include "kzentrack.h"
#include "kzentracklistview.h"

class KZenExplorer;
class KZenExplorerView;
class KZenItem;

/**
@author Andreas Mussgiller
*/
class KZenTrackView : public QWidget , public KZen
{
  Q_OBJECT

 public:

  KZenTrackView(KZenExplorer *,
		KZenExplorerView *,
		QWidget * parent = 0, 
		const char * name = 0);
  ~KZenTrackView();

  void                        setViewMode(ViewMode mode);
  void                        displayTrackList(QPtrList<KZenTrack> *, ViewMode vm, KZenItem *);
  void                        displayTrackListPL(KZenPlayList * pl);
  void                        addTrack(KZenTrack * track);
  void                        addTrack(KZenTrack * track, KZenPlayList * pl);

  void                        setSortColumn(KZen::TagField c);

  QPtrList<KZenTrackItem> &   selectedTracks();
  void                        setSearchText(const char * text);

  void                        setupActions();
  KZenPlayList *              currentPlayList() { return fCurrentPlayList; }

  void                        refresh();

 public slots:

  void                        searchChanged(const QString &);
  void                        searchReturnPressed(const QString &);
  void                        setBusy(bool busy = true);
  void                        itemDoubleClicked(QListViewItem * item, const QPoint & pnt, int c);
  void                        trackSelectionChanged();
  void                        sortChanged(int);
  void                        selectAll();

 protected:

  QPtrList<KZenTrackItem>     fSelectedTracks;

  ViewMode                    fViewMode;

  KZenExplorer               *fExplorer;
  KZenExplorerView           *fExplorerView;

  QVBox                      *fSearchAndList;

  KToolBar                   *fSearchToolBar;
  KComboBox                  *fSearchCombo;

  KZenTrackListView          *fTrackView;

  KZenItem                   *fCurrentNaviItem;
  KZenPlayList               *fCurrentPlayList;
  
  KAction                    *fSyncPlayList;

  bool                        fBusy;

  KZen::TagField              fSortColumn;
};

#endif
