//LabPlot : DumpDialog.h

#ifndef DUMPDIALOG_H
#define DUMPDIALOG_H

#include <qfont.h>
#include <qcheckbox.h>
#include "Worksheet.h"
#include "Dialog.h"

class DumpDialog: public Dialog
{
	Q_OBJECT
public:
	DumpDialog(class MainWin *mw, const char *name, int item);
public slots:
	void selectFile();
	void ok_clicked() { if(!apply_clicked()) accept(); }
	int apply_clicked();
private slots:
	void updateOptions(int item);
	void updateAudioFormat(int item) { updateOptions(3); }
	void updateImageFormat(int item) { updateOptions(4); }
private:
	void dumpASCII(QTextStream *t, QString sep);
	void dumpCDF(QString filename);
	void dumpNETCDF(QString filename);
	void dumpAUDIOFILE(QString filename);
	void dumpIMAGE(QString filename);
	class MainWin *mw;
	Plot *plot;
	int item;
	KLineEdit *startrow, *endrow, *samplele;
	QLabel *slabel, *flabel, *cdfcomlabel, *cdfenclabel, *audioformatlabel, *samplelabel;
	KComboBox *sc, *ic, *exportcb, *cdfcomcb, *cdfenccb, *audioformatcb;
	QCheckBox *imagecb, *compresscb, *headercb;
};

#endif //DUMPDIALOG_H
