//LabPlot : HistListDialog.cc

#include <stdio.h>
#include <stdlib.h>
#include <iostream>
#include <qstring.h>
#include <qlabel.h>
#include <qfiledialog.h>
#include <qcolordialog.h>
#include <klocale.h>
#include <kmessagebox.h>
#include "HistListDialog.h"

#ifdef HAVE_GSL
#include <gsl/gsl_histogram.h>
#endif

HistListDialog::HistListDialog(Worksheet *p, Spreadsheet *s, const char *name)
	: ListDialog(p, s, name)
{
	setCaption(i18n("Histogram Dialog"));

	QTabWidget *tw = new QTabWidget(vbox);
	QVBox *tab1 = new QVBox(tw);

	QHBox *hb = new QHBox(tab1);
	new QLabel(i18n(" From : "),hb);
	ale = new KLineEdit(QString("0"),hb);
	ale->setValidator(new QDoubleValidator(ale));
	new QLabel(i18n(" To : "),hb);
	int b=0;
	if(s)
		b=s->Table()->numRows();
	ble = new KLineEdit(QString::number(b),hb);
	ble->setValidator(new QDoubleValidator(ble));
	hb = new QHBox(tab1);
	new QLabel(i18n(" Bins : "),hb);
	binle = new KLineEdit(QString("100"),hb);
	binle->setValidator(new QIntValidator(binle));

	if (p) {
		updateRange();
		QObject::connect(lv,SIGNAL(selectionChanged()),SLOT(updateRange()));
	}
	
	Style style;
	Symbol symbol;
	QVBox *styletab;
	if(p && p->getPlot(p->API())->Type() == PSURFACE)
		styletab = surfaceStyle(tw);
	else
		styletab = simpleStyle(tw,0, &style, &symbol);

	tw->addTab(tab1,i18n("Parameter"));
	tw->addTab(styletab,i18n("Style"));

	QObject::connect(ok,SIGNAL(clicked()),SLOT(ok_clicked()));
        QObject::connect(apply,SIGNAL(clicked()),SLOT(apply_clicked()));

	setMinimumWidth(vbox->minimumSizeHint().width());
	setMinimumHeight(gbox->minimumSizeHint().height()+vbox->minimumSizeHint().height());
	resize(minimumSize());
}

void HistListDialog::apply_clicked() {
	// TODO : all selected graphs
	GraphList *gl = p->getPlot(p->API())->getGraphList();
	if(gl->getNumber()==0)
		return;
#ifdef HAVE_GSL
	int bins = (binle->text()).toInt();
	double a=(ale->text()).toDouble();
	double b=(ble->text()).toDouble();
	
	gsl_histogram *h = gsl_histogram_alloc (bins);
	gsl_histogram_set_ranges_uniform (h, a, b);
	
	if(s) {
		QTable *table = s->Table();
		int col = table->currentColumn();
		
		// add column if needed
		bool empty=TRUE;
		for(int i=0;i<table->numRows();i++) {
			if(table->text(i,table->numCols()-1).length()>0) {
				empty =FALSE;
			}
		}
		if (!empty)
			s->addColumn();

		// insert new data
		int newcol = table->numCols()-1;
		for (int i = 0;i<table->numRows();i++)
			gsl_histogram_increment(h,table->text(i,col).toDouble());
		
		// insert into last column
		for (int i = 0;i<bins;i++) {
			table->setText(i,newcol,QString::number(gsl_histogram_get (h,i)));
		}
		return;
	}

	int item = (int) (lv->itemPos(lv->currentItem())/lv->currentItem()->height());

	GRAPHType s = gl->getStruct(item);

	if (s == GRAPH2D) {
		Graph2D *g = gl->getGraph2D(item);
		int nx = g->Number();
		Point *ptr = new Point[nx];
		Point *data = g->Data();

		double xmin=0, xmax=1, ymin=0, ymax=1;

		for (int i = 0;i<nx;i++)
			gsl_histogram_increment(h,data[i].Y());

		for (int i = 0;i<bins;i++) {
			double x = i;
			double y = gsl_histogram_get (h,i);
			
			// new ranges
			if (i==0) {
				xmin=xmax=x;
				ymin=ymax=y;
			}
			else {
				x<xmin?xmin=x:0;
				x>xmax?xmax=x:0;
				y<ymin?ymin=y:0;
				y>ymax?ymax=y:0;
			}

			ptr[i].setPoint(x,y);
		}

		// create the new graph
		LRange range[2];
		range[0] = LRange(xmin,xmax);
		range[1] = LRange(ymin,ymax);
		
		QString fun = QString(i18n("histogram (")+QString::number(bins)+i18n(") of ")+g->Label());
		
		Style style(cb2->currentItem(),color->color(),filled->isChecked(),fcolor->color(),
			widthle->text().toInt(),pencb->currentItem(),brushcb->currentItem());
		Symbol symbol((SType)symbolcb->currentItem(),scolor->color(),ssize->text().toInt(),
			(FType)symbolfillcb->currentItem(),sfcolor->color(),sbrushcb->currentItem());
		
		Graph2D *ng = new Graph2D(fun,fun,range,SSPREADSHEET,P2D,style,symbol,ptr,bins);
		p->addGraph2D(ng);
	}
	else if (s == GRAPH3D) {
		// TODO
	}
	else if (s == GRAPHM) {
		// TODO
	}

	gsl_histogram_free (h);

	updateList();
#else
		KMessageBox::error(this, i18n("Sorry. Your installation doesn't support the GSL!"));
#endif
}
