//LabPlot : Plot3D.h

#ifndef PLOT3D_H
#define PLOT3D_H

#include "Plot.h"

class Plot3D:public Plot {
public:
	Plot3D(Worksheet *p);
	QStringList Info();
	~Plot3D() {}
	Axis *getAxis(int i) { return &axis[i]; }
	void saveAxes(QTextStream *t);
	void openAxes(QTextStream *t,int version);
	void enableGrid(int index,bool b) { gridenabled[index] = b; }
	bool gridEnabled(int index) { return gridenabled[index]; }
	void enableBorder(int index,bool b) { borderenabled[index] = b; }
	bool borderEnabled(int index) { return borderenabled[index]; }
	void draw(QPainter* p,int w, int h);
	void drawBorder(QPainter* p,int w, int h,bool hide);
	void drawCurves(QPainter* p,int w, int h);
	void drawAxes(QPainter* p,int w, int h, bool hide);
	void setBorder(int item, bool on);
	void setRanges(LRange* r) {range[0]=r[0];range[1]=r[1];range[2]=r[2];}
	void setActRanges(LRange* r) {actrange[0]=r[0];actrange[1]=r[1];actrange[2]=r[2];}
private:
	Axis axis[12];		// x, y, z, x2, y2, z2, x3, y3, z3, x4, y4, z4
	bool borderenabled[12];	// x, y, z, x2, y2, z2, x3, y3, z3, x4, y4, z4
	bool gridenabled[24];
	// x, xmin, y, ymin, z, zmin, x2, x2min, y2, y2min , z2, z2min, 
	// x3, x3min, y3, y3min, z3, z3min, x4, x4min, y4, y4min, z4, z4min
};

#endif // PLOT3D_H
