#
# spec file for LabPlot (SUSE Linux 10.0)
#
# Copyright (c) 2006 Stefan Gerlach.
# This file and all modifications and additions to the pristine
# package are under the same license as the package itself.
#
# Please submit bugfixes or comments to gerlach@mbi-berlin.de
#

%define version 1.5.1.rc2
%define release 1
Distribution:	SUSE Linux 10.0
BuildPrereq:	libjasper, libjpeg-devel, ImageMagick-devel, ImageMagick-Magick++-devel, fftw3-devel, audiofile-devel, gsl
Requires:	libjasper, ImageMagick, ImageMagick-Magick++, fftw3, audiofile, gsl

################################################################################

Name: 		LabPlot
URL:		http://labplot.sf.net/
Version:	%{version}
Release:	%{release}
Summary:	Function and Data Plotter
Source:		%{name}-%{version}.tar.bz2
Group:		Applications/Engineering	
License:	GPL
Packager:	Stefan Gerlach <gerlach@mbi-berlin.de>
Vendor:		http://labplot.sf.net/
BuildRoot:	%{_tmppath}/%{name}-%{version}-build

%description
LabPlot is a scientific program for plotting functions and to visualize and manipulate data.

Authors:
--------
	%{packager}

%prep
%setup

%build
%ifarch x86_64 sparc64 ppc64 amd64
CFLAGS="$CFLAGS -fPIC"
CXXFLAGS="$CXXFLAGS -fPIC"
./configure --prefix=/opt/kde3 --disable-static --enable-libsuffix=64 --with-qt-libraries=/usr/lib/qt3/lib64
%else
./configure --prefix=/opt/kde3 --disable-static
%endif
make

%clean
rm -rf $RPM_BUILD_ROOT
rm -rf $RPM_BUILD_DIR/%{name}-%{version}
rm -f ../file.list.%{name}

%install
make DESTDIR="$RPM_BUILD_ROOT" install
cd $RPM_BUILD_ROOT
find . -type d | sed '1,2d;s,^\.,\%attr(755\,root\,root) \%dir ,' > $RPM_BUILD_DIR/file.list.%{name}
find . -type f -o -type l | sed 's,^\.,\%attr(-\,root\,root) ,' >> $RPM_BUILD_DIR/file.list.%{name}

%post
/sbin/ldconfig

%postun
/sbin/ldconfig

%files -f ../file.list.%{name}
%doc README TODO INSTALL ChangeLog CHANGES FEATURES LabPlot.lsm

%changelog
* Sun Mar 12 2006 - Stefan Gerlach
- improved all sections
* Sat Mar 11 2006 - Stefan Gerlach
- update to 1.5.1
- generated files section
* Sun Oct 16 2005 - Stefan Gerlach
- update for 1.5.0.5
* Fri Oct 07 2005 - Stefan Gerlach
- created from SuSE 9.3 spec
