//LabPlot : Ellipse.cc

#include <math.h>
#include <iostream>
#include <kdebug.h>
#include "Ellipse.h"

using namespace std;

Ellipse::Ellipse(Point s,Point e,QColor c,int w, bool f, QColor fi) {
	start = s;
	end = e;
	color = c;
	width = w;
	filled = f;
	fillcolor = fi;
}

QStringList Ellipse::Info() {
	QStringList s;

	// no ellipse
	if(start.X() == end.X() && start.Y() == end.Y())
		return s;

        s << QString::number(start.X())+"/"+QString::number(start.Y());
        s << QString::number(end.X())+"/"+QString::number(end.Y());
	s << QString::number(width);
        s << color.name();
	s << QString::number(filled);
	s << fillcolor.name();

	return s;
}

// draw the line on the worksheet
void Ellipse::draw(QPainter *p, int X, int Y) {
//	kdDebug()<<"DRAW Ellipse from "<<X*start.X()<<'/'<<Y*start.Y()<<" to "<<X*end.X()<<'/'<<Y*end.Y()<<endl;

	if(fabs(end.X()-start.X())>1.0e-6) {
	        p->setPen(QPen(color,width));

		if (filled)
			p->setBrush(fillcolor);
		else
			p->setBrush(Qt::NoBrush);
		
		p->drawEllipse((int)(X*start.X()),(int)(Y*start.Y()),(int)(X*end.X()),(int)(Y*end.Y()));
	}
}

// save
void Ellipse::save(QTextStream *t) {
	*t<<start.X()<<' '<<start.Y()<<' '<<end.X()<<' '<<end.Y()<<endl;
	*t<<color.name()<<' '<<width<<' '<<filled<<' '<<fillcolor.name()<<endl;
}

// open
void Ellipse::open(QTextStream *t,int) {
//	kdDebug()<<"Ellipse::open() : "<<version<<endl;
	double sx,sy,ex,ey;
	QString colorstring,fillstring;
	int f;
	
	*t>>sx>>sy>>ex>>ey;

	start.setPoint(sx,sy);
	end.setPoint(ex,ey);
	
	*t>>colorstring>>width>>f>>fillstring;
	color=QColor(colorstring);
	filled=f;
	fillcolor=QColor(fillstring);
}

QDomElement Ellipse::saveXML(QDomDocument doc) {
	QDomElement ellipsetag = doc.createElement( "Ellipse" );

	QDomElement tag = doc.createElement( "Start" );
	tag.setAttribute("x",start.X());
	tag.setAttribute("y",start.Y());
    	ellipsetag.appendChild( tag );
	tag = doc.createElement( "End" );
	tag.setAttribute("x",end.X());
	tag.setAttribute("y",end.Y());
    	ellipsetag.appendChild( tag );
	tag = doc.createElement( "Color" );
    	ellipsetag.appendChild( tag );
  	QDomText t = doc.createTextNode( color.name() );
    	tag.appendChild( t );
	tag = doc.createElement( "Width" );
    	ellipsetag.appendChild( tag );
  	t = doc.createTextNode( QString::number(width) );
    	tag.appendChild( t );
	tag = doc.createElement( "Filled" );
    	ellipsetag.appendChild( tag );
  	t = doc.createTextNode( QString::number(filled) );
    	tag.appendChild( t );
	tag = doc.createElement( "FillColor" );
    	ellipsetag.appendChild( tag );
  	t = doc.createTextNode( fillcolor.name() );
    	tag.appendChild( t );
	
	return ellipsetag;
}

void Ellipse::openXML(QDomNode node) {
	while(!node.isNull()) {
		QDomElement e = node.toElement();
		kdDebug()<<"ELLIPSE TAG = "<<e.tagName()<<endl;
		kdDebug()<<"ELLIPSE TEXT = "<<e.text()<<endl;
	
		if(e.tagName() == "Start")
			start.setPoint(e.attribute("x").toDouble(),e.attribute("y").toDouble());
		else if(e.tagName() == "End")
			end.setPoint(e.attribute("x").toDouble(),e.attribute("y").toDouble());
		else if(e.tagName() == "Color")
			color = QColor(e.text());
		else if(e.tagName() == "Width")
			width = e.text().toInt();
		else if(e.tagName() == "Filled")
			filled = (bool) e.text().toInt();
		else if(e.tagName() == "FillColor")
			fillcolor = QColor(e.text());

		node = node.nextSibling();
	}
}

bool Ellipse::inside(int x, int y, int w, int h) {
//	kdDebug()<<"Ellipse inside() "<<endl;
	double W = w*end.X();
	double H = h*end.Y();
	// mid of ellipse
	double mx = w*start.X()+W/2;
	double my = h*start.Y()+H/2;

	// foci x values
	 if(W>H) {
		double f1x = mx-sqrt(W*W-H*H)/2.0;
		double f2x = mx+sqrt(W*W-H*H)/2.0;
		double d = sqrt((double)((x-f1x)*(x-f1x)+(y-my)*(y-my)))+ sqrt((double)((x-f2x)*(x-f2x)+(y-my)*(y-my)));
//		kdDebug()<<"x/y "<<x<<' '<<y<<" f1x/f2x "<<f1x<<' '<<f2x<<" my="<<my<<endl;
		if (d<W)
			return true;
	 }
	else {
		double f1y = my-sqrt(H*H-W*W)/2.0;
		double f2y = my+sqrt(H*H-W*W)/2.0;
		double d = sqrt((double)((x-mx)*(x-mx)+(y-f1y)*(y-f1y)))+ sqrt((double)((x-mx)*(x-mx)+(y-f2y)*(y-f2y)));	
//		kdDebug()<<"x/y "<<x<<' '<<y<<" f1y/f2y "<<f1y<<' '<<f2y<<" mx="<<my<<endl;
		if (d<H)
			return true;
	}

	return false;
}
