//LabPlot : FilterKexiDB.h

#ifndef FILTERKEXIDB_H
#define FILTERKEXIDB_H

#include <qstring.h>
#include <qstringlist.h>

#ifdef HAVE_KEXIDB
#include <kexidb/drivermanager.h>
#include <kexidb/driver.h>
#include <kexidb/connection.h>
#endif

class FilterKexiDB
{
public:
	FilterKexiDB(QString driver=0);
	QStringList Driver();
	QStringList Databases();
	QStringList Tables();
	int Fields();
	int Rows();
	QString fieldName(int col);
	
	int connectDriver(QString d);	// connect to driver d
	int connect(QString host, QString user, QString password);	//connect
	int connectDatabase(QString d);	// connect to database d
	int initialize(QString table);				// initialize schema and cursor
	int initWrite();
	int createTable(QString tablename, QStringList fieldlist);
	int writeData(QString *data, int cols, int rows);
	QString *Data();
private:
#ifdef HAVE_KEXIDB
	KexiDB::DriverManager manager;
	KexiDB::Driver *kexidriver;
	KexiDB::Connection *conn;
	KexiDB::ConnectionData conn_data;	// this must be global !
	KexiDB::TableSchema *schema;
	KexiDB::Cursor *cursor;
#endif
	QString driver;
};

#endif //FILTERKEXIDB_H
