//LabPlot : FilterListDialog.h

#ifndef FILTERLISTDIALOG_H
#define FILTERLISTDIALOG_H

#include "ListDialog.h"

class FilterListDialog : public ListDialog
{
	Q_OBJECT
public:
	FilterListDialog(MainWin *mw, const char *name);
public slots:
	int Type() { return typecb->currentItem(); }		//!< type of filter
	void setType(int t) { typecb->setCurrentItem(t); }	//!< set type of filter
	int Order() { return orderni->value(); }		//!< order of filter
	void setOrder(int o) { orderni->setValue(o); }		//!< set oder of filter
	double Cuttoff() { return cutoffle->text().toDouble(); }	//!< cutoff frequency
	void setCutoff(double c) { cutoffle->setText(QString::number(c)); }	//!< set cutoff frequency
	double Bandwidth() { return bandwidthle->text().toDouble(); }	//!< bandwidth of filter
	void setBandwidth(double b) { bandwidthle->setText(QString::number(b)); }	//!< set bandwidth of filter
	int Apply() { return apply_clicked(); }
private:
	double filter_calculate(double frequency);
	KComboBox *typecb;
	QLabel *cutofflabel, *bandwidthlabel;
	KIntNumInput *orderni;
	KLineEdit *cutoffle, *bandwidthle;
private slots:
	void saveSettings();
	int apply_clicked();
	void updateType(int);
};

#endif // FILTERLISTDIALOG_H
