//LabPlot : IntegrationListDialog.h

#ifndef INTEGRATIONLISTDIALOG_H
#define INTEGRATIONLISTDIALOG_H

#include "ListDialog.h"

class IntegrationListDialog : public ListDialog
{
	Q_OBJECT
public:
	IntegrationListDialog(MainWin *mw, const char *name);
public slots:
	void setRegion(double a, double b) { 						//!< set region for integration
		regioncb->setChecked(true);
		regionminle->setText(QString::number(a)); 
		regionmaxle->setText(QString::number(b)); 
	}
	void enableRegion(bool e=true) { regioncb->setChecked(e); }
	void setArea(bool a=true) { areacb->setChecked(a); }		//!< calculate area instead of integral
	void setBaseline(double v=0) { baselinecb->setChecked(true); baselinele->setText(QString::number(v)); }
														//!< set baseline for integration
	void enableBaseline(bool e=true) { baselinecb->setChecked(e); }
	void addGraph(bool a=true) { addgraph->setChecked(a); }	//!< add graph to plot
	void showInfo(bool a=true) { infocb->setChecked(a); }		//!< show info dialog
	QString Result() { return result; }				//!< get result of integration
	int Apply() { return apply_clicked(); }
private:
	QString result;
	KLineEdit *baselinele, *regionminle, *regionmaxle;
	QCheckBox *addgraph, *baselinecb, *areacb, *infocb, *regioncb;
private slots:
	void saveSettings();
	int apply_clicked();
};

#endif // INTEGRATIONLISTDIALOG_H
