//LabPlot : ProjectDialog.h

#ifndef PROJECTDIALOG_H
#define PROJECTDIALOG_H

#include <qfont.h>
#include <qcheckbox.h>
#include <kdeversion.h>
#if KDE_VERSION > 0x030104
#include <kdatetimewidget.h>
#endif
#include "Worksheet.h"
#include "Dialog.h"

class ProjectDialog: public Dialog
{
	Q_OBJECT
public:
	ProjectDialog(MainWin *mw, const char *name);
public slots:
	QString Title() { return titlele->text(); }
	void setTitle(QString t) { titlele->setText(t); }
	QString Author() { return authorle->text(); }
	void setAuthor(QString t) { authorle->setText(t); }
	QDateTime Created() { 
#if KDE_VERSION > 0x030104
		return created->dateTime(); 
#endif
		return QDateTime::currentDateTime();
	}
	void setCreated(QDateTime dt) { 
#if KDE_VERSION > 0x030104
		created->setDateTime(dt); 
#endif
	}	
	QDateTime Modified() { 
#if KDE_VERSION > 0x030104
		return modified->dateTime(); 
#endif
		return QDateTime::currentDateTime();
	}
	void setModified(QDateTime dt) { 
#if KDE_VERSION > 0x030104
		modified->setDateTime(dt); 
#endif
	}	
	QString Comment() { return commentle->text(); }
	void setComment(QString t) { commentle->setText(t); }

	void Apply() { apply_clicked(); }
private:
	Project *project;
	KLineEdit *titlele, *authorle, *commentle;
#if KDE_VERSION > 0x030104
	KDateTimeWidget *created, *modified;
#endif
private slots:
	void ok_clicked() { apply_clicked(); accept(); }
	void apply_clicked();
};

#endif //PROJECTDIALOG_H
