/*
 *   LADCCA
 *    
 *   Copyright (C) 2002, 2003 Robert Ham <rah@bash.sh>
 *    
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __LADCCA_CLIENT_H__
#define __LADCCA_CLIENT_H__

#include <pthread.h>

#include <ladcca/ladcca.h>
#include <ladcca/internal_headers.h>



struct _cca_client
{
  cca_args_t       *args;
  char             *class;

  short             server_connected;

  int               socket;

  pthread_mutex_t   events_in_lock;
  cca_list_t       *events_in;
  pthread_mutex_t   configs_in_lock;
  cca_list_t       *configs_in;
  pthread_mutex_t   comm_events_out_lock;
  cca_list_t       *comm_events_out;
  
  pthread_cond_t    send_conditional;

  int               recv_close;
  int               send_close;
  pthread_t         recv_thread;
  pthread_t         send_thread;
};

cca_client_t * cca_client_new ();
void           cca_client_destroy (cca_client_t *);

void cca_client_set_class (cca_client_t *, const char * class);


/* both of these return > 0 if a whole event was done, or
   -1 if there was an error */
int cca_comm_send_event (int socket, cca_comm_event_t * event);
int cca_comm_recv_event (int socket, cca_comm_event_t * event);

/* returns 0 on success, non-0 on error */
int cca_comm_connect_to_server (struct _cca_client *, const char * server, const char * service, struct _cca_connect_params *);

void * cca_comm_recv_run (void * data);
void * cca_comm_send_run (void * data);


#endif /* __LADCCA_CLIENT_H__ */

