/*
 *   LADCCA
 *    
 *   Copyright (C) 2002 Robert Ham <rah@bash.sh>
 *    
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __LADCCA_SOCKET_H__
#define __LADCCA_SOCKET_H__

/* returns -1 on error, -2 if the socket was closed, or buf_size */
int cca_sendall (int socket, void * buf, size_t buf_size, int flags);
int cca_recvall (int socket, void ** bufptr, size_t * buf_size, int flags);

/* returns 0 on success, non-0 on error */
int cca_open_socket (int * socket, const char * host, const char * service);

/* return hostname on success, or NULL on error */
const char * cca_lookup_peer_name (int sock);
const char * cca_lookup_peer_port (int sock);


#endif /* __LADCCA_SOCKET_H__ */
