/*
 *
 * Copyright 1998-1999, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Kinis L. Meyer with M. D. McNally 
 *          and Andrew Lumsdaine
 *
 * This file is part of the Notre Dame LAM implementation of MPI.
 *
 * You should have received a copy of the License Agreement for the
 * Notre Dame LAM implementation of MPI along with the software; see
 * the file LICENSE.  If not, contact Office of Research, University
 * of Notre Dame, Notre Dame, IN 46556.
 *
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 *
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.  
 *
 * Additional copyrights may follow.
 *
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	RBD/GDB
 *
 *	$Id: rtdinit.lam.c,v 6.3 1999/06/12 17:11:38 kmeyer1 Exp $
 * 
 *	Function:	- route table initializer
 */

#include <all_hash.h>
#include <net.h>
#include <rreq.h>
#include <terror.h>

/*
 * external functions
 */
extern int4		next_prime();

int4
rtdinit(pprtd)

HASH			**pprtd;

{
	int4		nroutes;	/* size of route table */
/*
 * Build the route table.
 */
	nroutes = next_prime(RNRENT);

	if ((*pprtd = ah_init(nroutes, (int4) sizeof(struct route),
			(int4) NOTNODEID, INT4_NIL)) == 0)
			lampanic("router (ah_init)");

	return(RDUMB);
}
