/*
 *
 * Copyright 1998-1999, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Kinis L. Meyer with M. D. McNally 
 *          and Andrew Lumsdaine
 *
 * This file is part of the Notre Dame LAM implementation of MPI.
 *
 * You should have received a copy of the License Agreement for the
 * Notre Dame LAM implementation of MPI along with the software; see
 * the file LICENSE.  If not, contact Office of Research, University
 * of Notre Dame, Notre Dame, IN 46556.
 *
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 *
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.  
 *
 * Additional copyrights may follow.
 *
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	NJN
 *
 *	$Id: wpost.c,v 1.0 1999/07/21 19:00:22 jsquyres Exp $
 *
 *	Function:	- post a window
 *	Accepts:	- group
 *			- assertion
 *			- window
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <errno.h>
#include <stdlib.h>

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>


int
MPI_Win_post(group, assertion, win)

MPI_Group		group;
int			assertion;
MPI_Win			win;

{
	int		rank;			/* rank in window */
	int		err;
	int		i;

	lam_initerr_m();
	lam_setfunc_m(BLKMPIWINPOST);
/*
 * Check arguments.
 */
	if (win == MPI_WIN_NULL) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPIWINPOST, lam_mkerr(MPI_ERR_WIN, 0)));
	}

	if (group == MPI_GROUP_NULL || group == MPI_GROUP_EMPTY) {
		return(lam_errfunc(win->w_comm,
			BLKMPIWINPOST, lam_mkerr(MPI_ERR_GROUP, 0)));

	}
/*
 * Check epoch.
 */
	if (win->w_flags & (LAM_WFEXPEPOCH | LAM_WFPOSTED)) {
		return(lam_errfunc(win->w_comm,
			BLKMPIWINPOST, lam_mkerr(MPI_ERR_EPOCH, 0)));
	}
/*
 * Send "i-post-u" messages.
 */
	win->w_flags |= LAM_WFPOSTED | LAM_WFNOOUT;
	win->w_ncomplete = group->g_nprocs;

	for (i = 0; i < group->g_nprocs; i++) {
		rank = lam_rank_in_group(win->w_comm->c_group,
						group->g_procs[i]);

		if (rank == MPI_UNDEFINED) {
			return(lam_errfunc(win->w_comm,
				BLKMPIWINPOST, lam_mkerr(MPI_ERR_GROUP, 0)));
		}

		win->w_pstate[rank] |= LAM_WFPOSTED;

		err = lam_osd_send(0, 0, MPI_BYTE, rank,
				LAM_OSD_POST, win->w_comm, TRUE, FALSE);

		if (err != MPI_SUCCESS) {
			return(lam_errfunc(win->w_comm, BLKMPIWINPOST, err));
		}
	}

        lam_resetfunc_m(BLKMPIWINPOST);
	return(MPI_SUCCESS);
}
