dnl -*- shell-script -*-

#
# $Id: lam_mutex_pshared.m4,v 1.1 2000/10/17 12:05:18 jsquyres Exp $
#
# This file is part of the University of Notre Dame implementation of
# LAM/MPI.  See the LICENSE file in the top-level directory for
# license and copyright details.

define(LAM_MUTEX_PSHARED,[
AC_MSG_CHECKING(for process shared pthread mutex)
AC_TRY_RUN([#include <pthread.h>
int main(int argc, char* argv[]) {
  pthread_mutex_t m; pthread_mutexattr_t mattr;
  if (pthread_mutexattr_init(&mattr)) return(1);
  if (pthread_mutexattr_setpshared(&mattr, PTHREAD_PROCESS_SHARED)) return(1);
  if (pthread_mutex_init(&m, &mattr)) return(-1);
  return(0);
}], lam_ac_mutex_pshared=yes, lam_ac_mutex_pshared=no, lam_ac_mutex_pshared=no)
AC_MSG_RESULT($lam_ac_mutex_pshared)
])
