// $Id: isend.cc,v 1.1.1.1.2.1 2001/10/29 04:32:57 bbarrett Exp $
//
// Copyright 1997-2001, University of Notre Dame.
// Authors: Jeffrey M. Squyres, Jeremy G. Siek, Michael P. McNally, and
//          Andrew Lumsdaine
// 
// This file is part of the Notre Dame C++ bindings for MPI.
// 
// You should have received a copy of the License Agreement for the Notre
// Dame C++ bindings for MPI along with the software; see the file
// LICENSE.  If not, contact Office of Research, University of Notre
// Dame, Notre Dame, IN 46556.
// 
// Redistribution and use in source and binary forms, with or without
// modification, are permitted subject to the conditions specified in the
// LICENSE file.
// 
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
// INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
// STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
// IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
// POSSIBILITY OF SUCH DAMAGE.
// 
// Additional copyrights may follow.
/****************************************************************************

 MESSAGE PASSING INTERFACE TEST CASE SUITE

 Copyright IBM Corp. 1995

 IBM Corp. hereby grants a non-exclusive license to use, copy, modify, and
 distribute this software for any purpose and without fee provided that the
 above copyright notice and the following paragraphs appear in all copies.

 IBM Corp. makes no representation that the test cases comprising this
 suite are correct or are an accurate representation of any standard.

 In no event shall IBM be liable to any party for direct, indirect, special
 incidental, or consequential damage arising out of the use of this software
 even if IBM Corp. has been advised of the possibility of such damage.

 IBM CORP. SPECIFICALLY DISCLAIMS ANY WARRANTIES INCLUDING, BUT NOT LIMITED
 TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS ON AN "AS IS" BASIS AND IBM
 CORP. HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
 ENHANCEMENTS, OR MODIFICATIONS.

****************************************************************************

 These test cases reflect an interpretation of the MPI Standard.  They are
 are, in most cases, unit tests of specific MPI behaviors.  If a user of any
 test case from this set believes that the MPI Standard requires behavior
 different than that implied by the test case we would appreciate feedback.

 Comments may be sent to:
    Richard Treumann
    treumann@kgn.ibm.com

****************************************************************************
*/
#include "mpi2c++_test.h"


extern int to, from;

static int data_isend[1000];
static int werror = 1; // This is which call to wstart the error occurs.
static MPI::Request *req = 0;
 
void wstart();

void
isend()
{
  char msg[150];
  int buf[10000];
  int i; 
  int size;
  void* oldbuf;

  req = new MPI::Request[comm_size * 2];
  for(i = 0; i < comm_size * 2; i++)
    req[i] = MPI::REQUEST_NULL;

  Testing("Isend / Irecv");

  for(i = 0; i < comm_size; i++)  
    data_isend[i] = -1;

  for(i = 0; i < comm_size; i++) {
    req[2 * i] = MPI::COMM_WORLD.Isend(&my_rank, 1, MPI::INT, i, 1);
    req[2 * i + 1] = MPI::COMM_WORLD.Irecv(&data_isend[i], 1, MPI::INT, i, 1);
  }
 
  wstart();

  Pass(); // Isend / Irecv

  Testing("Issend / Irecv");
  
  for(i = 0; i < comm_size; i++)
    data_isend[i] = -1;
  
  for(i = 0; i < comm_size; i++) {
    req[2 * i] = MPI::COMM_WORLD.Issend(&my_rank, 1, MPI::INT, i, 1);
    req[2 * i + 1] = MPI::COMM_WORLD.Irecv(&data_isend[i], 1, MPI::INT, i, 1);
  }
  
  wstart();

  Pass(); // Issend / Irecv

  Testing("Irsend / Irecv");

  for(i = 0; i < comm_size; i++)
    data_isend[i] = -1;
  
  for(i = 0; i < comm_size; i++)  
    req[2 * i + 1] = MPI::COMM_WORLD.Irecv(&data_isend[i], 1, MPI::INT, i, 1);
  
  MPI::COMM_WORLD.Barrier();
  
  for(i = 0; i < comm_size; i++)
    req[2 * i] = MPI::COMM_WORLD.Irsend(&my_rank, 1, MPI::INT, i, 1);
  
  wstart();
  
  Pass(); // Irsend / Irecv

  Testing("Ibsend / Irecv");

  if (flags[SKIP_IBM21014])
    Done("Skipped (IBM 2.1.0.14)");
  else if (flags[SKIP_IBM21015])
    Done("Skipped (IBM 2.1.0.15)");
  else if (flags[SKIP_IBM21016])
    Done("Skipped (IBM 2.1.0.16)");
  else if (flags[SKIP_IBM21017])
    Done("Skipped (IBM 2.1.0.17)");
  else {
    MPI::Attach_buffer(buf, sizeof(buf));

    for(i = 0; i < comm_size; i++)  
      data_isend[i] = -1;
    
    for(i = 0; i < comm_size; i++) {
      req[2 * i] = MPI::COMM_WORLD.Ibsend(&my_rank, 1, MPI::INT, i, 1);
      req[2 * i + 1] = MPI::COMM_WORLD.Irecv(&data_isend[i], 1, MPI::INT, i, 1);
    }
    
    wstart();
    
    size = MPI::Detach_buffer(oldbuf); 
    if (size != sizeof(buf)) {
      sprintf(msg, "NODE %d - 0) ERROR, buffer not detached", my_rank);
      Fail(msg);
    }
    Pass(); // Ibsend / Irecv
  }

  for(i = 0; i < (comm_size * 2); i++)
    if(req[i] != MPI::REQUEST_NULL)
      req[i].Free();
  delete[] req;
}

void wstart()
{
  char msg[150];
  int i;
  MPI::Status *stats;
  stats = new MPI::Status[comm_size * 2];

  MPI::Request::Waitall(2 * comm_size, req, stats);
  
  for(i = 0; i < comm_size; i++)
    if(data_isend[i] != i) {
      sprintf(msg, "NODE %d - %d) ERROR after MPI::Waitall, data_isend = %d, should be %d" ,my_rank, werror, data_isend[i], i);
      Fail(msg);
    }
  delete[] stats;

  werror++;
}
