// $Id: pack_test.cc,v 1.1.1.1.2.1 2001/10/29 04:32:57 bbarrett Exp $
//
// Copyright 1997-2001, University of Notre Dame.
// Authors: Jeffrey M. Squyres, Jeremy G. Siek, Michael P. McNally, and
//          Andrew Lumsdaine
// 
// This file is part of the Notre Dame C++ bindings for MPI.
// 
// You should have received a copy of the License Agreement for the Notre
// Dame C++ bindings for MPI along with the software; see the file
// LICENSE.  If not, contact Office of Research, University of Notre
// Dame, Notre Dame, IN 46556.
// 
// Redistribution and use in source and binary forms, with or without
// modification, are permitted subject to the conditions specified in the
// LICENSE file.
// 
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
// INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
// STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
// IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
// POSSIBILITY OF SUCH DAMAGE.
// 
// Additional copyrights may follow.
//

#include "mpi2c++_test.h"

void
pack_test()
{
  char buffer[100];
  char msg[150];
  double din;
  double dout;
  int iin;
  int iout;
  int position;

  din = 66.6;
  dout = 0.0;
  iin = 69;
  iout = 0;
  position = 0;

  Testing("Pack / Unpack");

  MPI::INT.Pack(&iin, 1, buffer, sizeof(buffer), position, MPI::COMM_WORLD);
  MPI::DOUBLE.Pack(&din, 1, buffer, sizeof(buffer), position, MPI::COMM_WORLD);

  position = 0;

  MPI::INT.Unpack(buffer, sizeof(buffer), &iout, 1, position, MPI::COMM_WORLD);
  MPI::DOUBLE.Unpack(buffer, sizeof(buffer), &dout, 1, position, 
		     MPI::COMM_WORLD);

  if (iout != iin) {
    sprintf(msg, "NODE %d - 1) ERROR in pack/unpack, iout = %d, should be %d",
	    my_rank, iout, iin);
    Fail(msg);
  }

  if (dout != din) {
    sprintf(msg, "NODE %d - 2) ERROR in pack/unpack, dout = %f, should be %f",
	    my_rank, dout, din);
    Fail(msg);
  }

  Pass(); // Pack / Unpack
}
