/*
 * $Copyright$
 *
 * $Id: host_long.cc,v 1.6 2000/10/19 03:29:40 jsquyres Exp $
 *
 *	Function:	- holds the remaining packets of a long message
 *                      - indexed on the pk_srqid (IMPI_Uint8)
 *                      - first packet of each long message has already 
 *                        been sent
 *                      - when a SYNC ACK is found in this table, we fill 
 *                        in the pk_drqid and place the remaining packets 
 *                        on the destination host queue
 *
 */

#include <lam_config.h>
#if LAM_WANT_IMPI

#include <map>

#include <impi-defs.h>
#include <impi.h>
#include <impid-cc.h>
#include <debug-cc.h>


/*
 * local typedef for our map
 * Map indexed on IMPI_Uint8 (srqid)
 * Map contains a pointer to a list of IMPI packet wrappers
 */
using std::map;
typedef map<IMPI_Uint8, packet_mgmt_list*> host_long_map;


/*
 * private variables
 */
static host_long_map long_map;
static Debug debug(false);


/*
 *	host_long_init
 *
 *	Function:	- initialize host long map
 *
 *      Returns:        - 0 for success, LAMERROR on error
 */
int
host_long_init()
{
  // Don't need to do anything yet

  return 0;
}

/*
 *	host_expect_long_ack
 *
 *	Function:	- puts a list of packets in the map as expecting an 
 *                        long ack from a remote IMPI host
 *                      - indexed on srqid
 *
 *	Accepts:	- srqid 
 *                      - list of packets
 *      Returns:        - 0 for success, LAMERROR on error
 */
int
host_expect_long_ack(IMPI_Uint8 srqid, packet_mgmt_list* plist)
{
  host_long_map::iterator i;

  // If the srqid is in the map already, this is an error

  debug << "Trying to register for long ACK from a host for srqid " 
	<< (int) srqid << endl;
  i = long_map.find(srqid);
  if (i == long_map.end())
    long_map[srqid] = plist;
  else
    return (LAMERROR);

  return 0;
}


/*
 *	host_find_long_ack
 *
 *	Function:	- find a pending SYNCACK in the map
 *                      - if found, return the rest of packets for a 
 *                        long message that need to be sent, and delete 
 *                        the srqid from the map
 *                      - indexed on srqid
 *
 *	Accepts:	- srqid 
 *      Returns:        - ptr to list of packets if found, 0 if not found
 */
packet_mgmt_list*
host_find_long_ack(IMPI_Uint8 srqid, bool wantErase)
{
  host_long_map::iterator i;
  packet_mgmt_list *ret = 0;

  // If found, return the list, and erase from the map

  i = long_map.find(srqid);
  if (i != long_map.end()) {
    ret = (*i).second;
    if (wantErase)
      long_map.erase(i); // complexity for removing by iterator is constant
  }

  return ret;
}


/*
 *	host_long_destrong
 *
 *	Function:	- destroy host long map
 *
 *      Returns:        - 0 for success, LAMERROR on error
 */
int
host_long_destroy()
{
  host_long_map::iterator i;

  for (i = long_map.begin(); i != long_map.end(); i++) {
    debug << "Deleting host_long" << endl;
    delete (*i).second;
  }

  long_map.clear();

  return 0;
}


#endif
