/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Arun Rodrigues, and Brian Barrett with
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted subject to the conditions specified in the
 * LICENSE file.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 * Additional copyrights may follow.
 * 
 *	Ohio Trollius
 *	Copyright 1994 The Ohio State University
 *	GDB
 *
 *	$Log: kexit.c,v $
 *	Revision 6.2  1999/06/12 17:11:36  kmeyer1
 *	added copyright
 *	
 *	Revision 6.1  1996/11/23 18:45:15  nevin
 *	Ohio Release
 *	
 * Revision 6.0  96/02/29  13:32:12  gdburns
 * Ohio Release
 * 
 * Revision 5.2  94/08/22  13:51:14  gdburns
 * Ohio Release
 * 
 * Revision 5.1.1.1  94/08/18  11:11:44  gdburns
 * overhaul for new kernel
 * 
 * Revision 5.1  94/05/18  10:42:45  gdburns
 * Ohio Release
 * 
 * Revision 2.3  94/04/22  12:28:17  gdburns
 * Ohio Release
 * 
 * Revision 2.2  94/02/16  14:22:54  gdburns
 * pre-release to 2.3
 * 
 *	Function:	- exits internal process
 *	Accepts:	- return code
 */

#include <kreq.h>

/*
 * external functions
 */
extern int		_cipc_kreq();		/* make kernel request */
extern int		kbgetpid();

void
kexit(status)

int			status;

{
	struct kreq	req;			/* kernel request */
	struct kreply	reply;			/* kernel reply */
/*
 * Formulate the KQDETACH kernel request.
 */
	req.kq_req = KQDETACH;
	req.kq_pid = kbgetpid();
	_cipc_kreq(&req, &reply);
}
