/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Arun Rodrigues, and Brian Barrett with
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted subject to the conditions specified in the
 * LICENSE file.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 * Additional copyrights may follow.
 * 
 *	Ohio Trollius
 *	Copyright 1995 The Ohio State University
 *	GDB
 *
 *	$Log: trillium.c,v $
 *	Revision 6.2  1999/06/12 17:11:37  kmeyer1
 *	added copyright
 *	
 *	Revision 6.1  1996/11/23 18:45:24  nevin
 *	Ohio Release
 *	
 * Revision 6.0  96/02/29  13:32:16  gdburns
 * Ohio Release
 * 
 *	Function:	- internal client access to local servers
 */

#include <portable.h>
#include <preq.h>
#include <t_types.h>
#include <typical.h>
#include <terror.h>

/*
 * external functions
 */
extern char		*flforget();
extern int		*pdoom();

/*
 *	rforget
 *
 *	Function:	- translates tag to address
 *	Accepts:	- server node ID (not used, always local)
 *			- flag tag
 *	Returns:	- address or 0
 */
char
*rforget(nodeid, tag)

int4			nodeid;
int4			tag;

{
	return(flforget(tag));
}

/*
 *	rpdoom
 *
 *	Function:	- delivers a signal to kenyad process(es)
 *	Accepts:	- server node ID (not used, always local)
 *			- process selection method
 *			- selection value
 *			- signal number
 *	Returns:	- 0 or ERROR
 */
int
rpdoom(nodeid, flags, value, sig)

int4			nodeid;
int4			flags;
int4			value;
int4			sig;

{
	struct preq	request;	/* kenya request */
	struct preply	reply;		/* kenya reply */

	request.pq_sel_method = flags;
	request.pq_sel_value = value;
	request.pq_signal = sig;

	pdoom(&request, &reply);

	if (reply.pr_reply) {
		errno = ttol(reply.pr_reply);
		return(LAMERROR);
	} else {
		return(0);
	}
}
