/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Arun Rodrigues, and Brian Barrett with
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted subject to the conditions specified in the
 * LICENSE file.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 * Additional copyrights may follow.
 * 
 *	Software for Humanity
 *	RBD
 *
 *	This program is freely distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 *	$Id: all_squeue.c,v 6.2 1999/05/24 16:56:47 kmeyer1 Exp $
 * 
 *	Function:	- generic queue management code
 *			- fully static version
 *				- aqs_init(): create a queue
 *			- other functions macro'ed to the dynamic version
 */

#include <errno.h>

#include <all_queue.h>
#include <portable.h>

/*
 *	aqs_init
 *
 *	Function:	- creates a static queue
 *	Accepts:	- size of queue
 *			- size of queue element
 *			- queue array
 *			- static queue descriptor
 *	Returns:	- static queue descriptor or NULL
 */
SQUEUE *
aqs_init(size, elemsize, queue, aqsd)

int4			size;
int4			elemsize;
void			*queue;
SQUEUE			*aqsd;

{
	if ((size <= 0) || (elemsize <= 0)) {
		errno = EINVAL;
		return((SQUEUE *) 0);
	}
/*
 * Initialize the queue descriptor.
 */
	aqsd->aq_maxnelem = size;
	aqsd->aq_elemsize = elemsize;
	aqsd->aq_nelem = 0;
	aqsd->aq_first = 0;
	aqsd->aq_last = 0;
	aqsd->aq_queue = queue;

	return(aqsd);
}
