/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Arun Rodrigues, and Brian Barrett with
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted subject to the conditions specified in the
 * LICENSE file.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 * Additional copyrights may follow.
 * 
 *	Ohio Trollius
 *	Copyright 1993 The Ohio State University
 *	RBD
 *
 *	$Log: memucmp.c,v $
 *	Revision 6.2  1999/05/24 16:56:49  kmeyer1
 *	added $copyright$
 *	
 *	Revision 6.1  1996/11/23 19:58:02  nevin
 *	Ohio Release
 *	
 * Revision 6.0  96/02/29  13:47:22  gdburns
 * Ohio Release
 * 
 * Revision 5.2  94/08/22  13:57:04  gdburns
 * Ohio Release
 * 
 * Revision 5.1  94/05/18  10:56:52  gdburns
 * Ohio Release
 * 
 * Revision 2.3  94/04/22  12:35:01  gdburns
 * Ohio Release
 * 
 * Revision 2.2  93/07/22  13:58:47  raja
 * pre-release to 2.3
 * 
 *	Function:	- compare arrays of bytes (unsigned characters)
 *	Accepts:	- ptr to first array
 *			- ptr to second array
 *			- # of bytes
 *	Returns:	- -1, 0, +1 (m1 < m2, m1 == m2, m1 > m2)
 */

#include <portable.h>

int
memucmp(m1, m2, nbytes)

unsigned char		*m1;
unsigned char		*m2;
int4			nbytes;

{
	for (; nbytes > 0; --nbytes, ++m1, ++m2) {

		if (*m1 < *m2) {
			return(-1);
		}
		else if (*m1 > * m2) {
			return(1);
		}
	}

	return(0);
}
