/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Arun Rodrigues, and Brian Barrett with
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted subject to the conditions specified in the
 * LICENSE file.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 * Additional copyrights may follow.
 * 
 *
 *	$Id: iabort.c,v 1.1 1999/08/26 20:12:31 jsquyres Exp $
 *
 *	Function:	- send an abort message to the LAM IMPI host
 */

#include <lam_config.h>
#if LAM_WANT_IMPI

#include <impi-defs.h> /* This file supplied by IMPI server package */
#include <impi.h>
#include <debug.h>
#include <mpisys.h>


/*
 * private variables
 */
static int              fl_debug = 0;


int
IMPI_Abort(void)
{
  int impid_rank;

  MPI_Comm_size(impid_comm, &impid_rank);
  impid_rank--;
  if (MPI_Send((void *) 0, 0, MPI_BYTE, impid_rank, IMPI_ABORT_TAG, 
	       impid_comm) != MPI_SUCCESS)
    return (LAMERROR);
  DBUG("IMPI_ABORT_TAG message sent\n");

  return 0;
}

#endif /* LAM_WANT_IMPI */

