/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Arun Rodrigues, and Brian Barrett with
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted subject to the conditions specified in the
 * LICENSE file.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 * Additional copyrights may follow.
 * 
 *
 *	$Id: imk_dtype.c,v 1.7 2000/10/25 23:24:23 jsquyres Exp $
 *
 *	Function:	Make a datatype for IMPI meta messages
 *                      
 */

#include <lam_config.h>
#if LAM_WANT_IMPI
#include <stdio.h>
#include <errno.h>

#include <app_mgmt.h>
#include <net.h>
#include <rpisys.h>
#include <terror.h>
#include <typical.h>
#include <kreq.h>
#include <events.h>
#include <debug.h>
#include <impi-defs.h>
#include <impi.h>


/*
 * Exported variables
 */
MPI_Datatype IMPI_LAMGIAPPE = MPI_DATATYPE_NULL;
MPI_Datatype IMPI_TYPE_UINT8 = MPI_DATATYPE_NULL;


/*
 * private variables
 */
static int fl_debug = 0;


int 
IMPI_Make_dtype() 
{
  int lengths[2];
  MPI_Aint disps[2];
  MPI_Datatype oldtypes[2];
  IMPI_Lamgiappe lamgiappe;

  /* Make a datatype for the IMPI_Uint8 type */

  if (sizeof(unsigned int) == 8)
    IMPI_TYPE_UINT8 = MPI_UNSIGNED;
  else if (sizeof(unsigned long) == 8)
    IMPI_TYPE_UINT8 = MPI_UNSIGNED_LONG;
  else if (sizeof(unsigned long long) == 8)
    IMPI_TYPE_UINT8 = MPI_UNSIGNED_LONG_LONG;
  else
    return (LAMERROR);

  /* Make the datatype for IMPI_Lamgiappe */

  DBUG("Making the IMPI_Lamgiappe datatype\n");

  lengths[0] = 1;
  lengths[1] = (sizeof(IMPI_Lamgiappe) - sizeof(IMPI_Uint8)) / sizeof(int);
  disps[0] = ((char*) &lamgiappe.srqid) - ((char*) &lamgiappe);
  disps[1] = ((char*) &lamgiappe.local_src_rank) - ((char*) &lamgiappe);
  oldtypes[0] = IMPI_TYPE_UINT8;
  oldtypes[1] = MPI_INT;

  MPI_Type_create_struct(2, lengths, disps, oldtypes, &IMPI_LAMGIAPPE);
  MPI_Type_commit(&IMPI_LAMGIAPPE);

  return MPI_SUCCESS;
}

#endif
