/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Arun Rodrigues, and Brian Barrett with
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted subject to the conditions specified in the
 * LICENSE file.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 * Additional copyrights may follow.
 * 
 *
 *      $Id: dl_inet.h,v 6.5.2.1 2001/10/07 17:20:47 bbarrett Exp $
 * 
 *	Function:	- dli/dlo_inet constants and templates
 */

#ifndef _DL_INET
#define _DL_INET

#include <sys/types.h>
#include <netinet/in.h>

#include <lam_config.h>
#include <portable.h>
#include <net.h>

/*
 * dli/dlo common constants
 */
#define TO_DLO_ESTIMATE	200		/* timeout estimate count trigger */

#define DLDEFPORT	5555		/* default dl_inet port */
#define DLMAXSEQ	0x40000000	/* max sequence # */
#define DLMINFRAMELEN	(sizeof(struct dlframe) - MAXNMSGLEN)
					/* header-only frame size */

/*
 * dlo constants
 */
#define DOSLOTCNT	8		/* max # window slots */
#define DOMAXPENDING	3		/* max # pending messages */
#define DOMAXSTALE	((int) (LAM_TO_DLO_IDLE / (LAM_TO_DLO_ACK / 1000000.0)))
					/* causes an alive message */
#ifndef DOMAXRESEND
#define DOMAXRESEND	300		/* max # resends per message */
#endif

/*
 * dlo slot flags
 */
#define DORESEND	1		/* resend-on-timeout flag */
#define DOPENDING	2		/* message pending */
#define DORESERVED	4		/* reserved for receive */

/*
 * sequence macros
 */
#define	seqinc(a) ((a + 1) % DLMAXSEQ)
#define	seqmin(a, b) (((b - a) > 0) ? (((b - a) > (DLMAXSEQ / 2)) ? b : a) : \
		(((a - b) > (DLMAXSEQ / 2)) ? a : b))

/*
 * dlo requests
 */
#define DOQSETLINK	0
#define DOQREMLINK	1
#define DOQGETLINKS	2
#define DOQVOPEN	3		/* open dlo valve */
#define DOQVCLOSE	4		/* close dlo valve */

/*
 * dli requests
 */
#define DIQSETLINK	0
#define DIQSANITY	1
#define DIQREMLINK	2

/*
 * dlo request template
 */
struct doreq {
	int4		doq_req;	/* request code */
	int4		doq_src_node;	/* client node */
	int4		doq_src_event;	/* client event */
	int4		doq_link;	/* output link */
	int4		doq_extra;	/* extra information */
};

/*
 * dlo reply
 */
struct doreply {
	int4		dor_reply;	/* reply code */
	int4		dor_nlinks;	/* # datalinks */
};

/*
 * dli request
 */
struct direq {
	int4		diq_req;	/* request code */
	int4		diq_src_node;	/* client node */
	int4		diq_src_event;	/* client event */
	int4		diq_link;
};

/*
 * dli reply
 */
struct direply {
	int4		dir_reply;	/* reply code */
};

/*
 * output datalink
 */
struct dolink {
	int4		dol_link;	/* link number */
	int4		dol_seqgive;	/* next assignable sequence # */
	int4		dol_seqsend;	/* next sendable sequence # */
	int4		dol_npending;	/* # pending seq. # */
	int4		dol_idle;	/* idle timeout periods */
	struct sockaddr_in
			dol_addr;	/* dli socket address */
};

/*
 * input datalink
 */
struct dilink {
	int4		dil_link;	/* link number */
	int4		dil_seqrecv;	/* next recvable sequence # */
	struct sockaddr_in
			dil_addr;	/* dli socket address */
};

/*
 * network portion of struct nmsg
 */
struct dlheader {
	int4		dlh_node;
	int4		dlh_event;
	int4		dlh_type;
	int4		dlh_length;
	int4		dlh_flags;
	int4		dlh_data[NHDSIZE];
};

/*
 * datalink frame
 */
struct dlframe {
	int4		dlf_src_node;	/* message source node */
	int4		dlf_seqnum;	/* message sequence # */
	struct dlheader	dlf_msghead;	/* message header */
	char		dlf_msg[MAXNMSGLEN];
					/* message body */
};

struct doslot {
	int4		dos_link;	/* outgoing link */
	int4		dos_flags;	/* slot status flags */
	int4		dos_resend;	/* # resends */
	struct dlframe	dos_frame;	/* datalink frame */
};

struct dlack {
	int4		dla_seqnum;	/* ack sequence # */
	int4		dla_destid;	/* destination node */
};

#ifdef __cplusplus
extern "C" {
#endif

extern int		ldogetlinks __ARGS((struct dolink **pdol,int4 *pndol));
extern int		ldosetlink __ARGS((struct dolink *pdol));
extern int		ldoremlink __ARGS((int4 link));

#ifdef __cplusplus
}
#endif

#endif /* _DL_INET */
