/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Arun Rodrigues, and Brian Barrett with
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted subject to the conditions specified in the
 * LICENSE file.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 * Additional copyrights may follow.
 * 
 *
 *	$Id: etc_misc.h,v 1.5 2000/11/04 16:32:12 jsquyres Exp $
 *
 *	Function:	- some radom C declarations for internal LAM functions
 */

#ifndef _LAM_ETC_MISC_H_
#define _LAM_ETC_MISC_H_

#include <portable.h>

/*
 * share/etc/show_version.c
 */
void lam_show_version(int verbose);

/*
 * share/etc/few.c
 */
int _lam_few(char *argv[]);

/*
 * share/etc/bootsockio.h
 */
int readsockint4(int sock, int4 *pdata);
int writesockint4(int sock, int4 data);
int readcltcoord(int sock, int4 *pstrport, int4 *pudpport);
int writecltcoord(int sock, int4 strport, int4 udpport);
int readcltnbr(int sock, int4 *plink, unsigned char *phostaddr,
	       int4 *pport, int4 *pnum_cpus);
int writecltnbr(int sock, int4 link, unsigned char *hostaddr,
		int4 port, int4 num_cpus);

/*
 * share/etc/nodespin.c
 */
void nodespin_init(char *msg);
void nodespin_next(int4 node);
void nodespin_end(void);

/*
 * share/etc/prime.c
 */
int is_prime(int4 n);
int4 next_prime(int4 n);


#endif
