/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Arun Rodrigues, and Brian Barrett with
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted subject to the conditions specified in the
 * LICENSE file.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 * Additional copyrights may follow.
 * 
 *
 *	LAM
 *	Copyright 1997 The Ohio State University
 *	RBD/GDB/NJN
 *
 *	$Id: t_types.h,v 6.6 2001/02/03 17:48:37 jsquyres Exp $
 *
 *	Function:	- defines type conversions
 */

#ifndef _T_TYPES
#define _T_TYPES

#include <lam_config.h>
#include <portable.h>

/*
 * Integer conversions.
 */
#if WORDS_BIGENDIAN

#define ltot(x)		(x)
#define ttol(x)		(x)
#define ltoti2(x, y)	*((uint2 *) (y)) = *((uint2 *) (x))
#define ttoli2(x, y)	*((uint2 *) (y)) = *((uint2 *) (x))
#define ltoti4(x, y)	*((uint4 *) (y)) = *((uint4 *) (x))
#define ttoli4(x, y)	*((uint4 *) (y)) = *((uint4 *) (x))
#if (LAM_SIZEOF_LONG_LONG == 8) || (LAM_SIZEOF_LONG == 8) || (LAM_SIZEOF_INT == 8)
#define ltoti8(x, y)	*((uint8 *) (y)) = *((uint8 *) (x))
#define ttoli8(x, y)	*((uint8 *) (y)) = *((uint8 *) (x))
#endif
#define mltoti2(x, l)
#define mttoli2(x, l)
#define mltoti4(x, l)
#define mttoli4(x, l)
#define mltoti8(x, l)
#define mttoli8(x, l)


#else /* not WORDS_BIGENDIAN */

#define ltot(x)		rw(x)
#define ttol(x)		rw(x)
#define ltoti2(x, y)	revn(x, y, 2)
#define ttoli2(x, y)	revn(x, y, 2)
#define ltoti4(x, y)	rev4(x, y)
#define ttoli4(x, y)	rev4(x, y)
#define ltoti8(x, y)	rev8(x, y)
#define ttoli8(x, y)	rev8(x, y)
#define mltoti2(x, l)	mrevn(x, 2, l)
#define mttoli2(x, l)	mrevn(x, 2, l)
#define mltoti4(x, l)	mrev4(x, l)
#define mttoli4(x, l)	mrev4(x, l)
#define mltoti8(x, l)	mrev8(x, l)
#define mttoli8(x, l)	mrev8(x, l)

#endif /* not WORDS_BIGENDIAN */

/*
 * Floating point conversions.
 */
#if HAVE_IEEE_FP

#if WORDS_BIGENDIAN

#define ltotf4(x, y)	*((float4 *) (y)) = *((float4 *) (x))
#define ttolf4(x, y)	*((float4 *) (y)) = *((float4 *) (x))
#define ltotf8(x, y)	*((float8 *) (y)) = *((float8 *) (x))
#define ttolf8(x, y)	*((float8 *) (y)) = *((float8 *) (x))
#define mltotf4(x, l)
#define mttolf4(x, l)
#define mltotf8(x, l)
#define mttolf8(x, l)

#else /* not WORDS_BIGENDIAN */

#define ltotf4(x, y)	rev4(x, y)
#define ttolf4(x, y)	rev4(x, y)
#define ltotf8(x, y)	rev8(x, y)
#define ttolf8(x, y)	rev8(x, y)
#define mltotf4(x, l)	mrev4(x, l)
#define mttolf4(x, l)	mrev4(x, l)
#define mltotf8(x, l)	mrev8(x, l)
#define mttolf8(x, l)	mrev8(x, l)

#endif /* not WORDS_BIGENDIAN */

#else /* not HAVE_IEEE_FP */

#define ltotf4(x, y)	ltoieeef(x, y)
#define ttolf4(x, y)	ieeetolf(x, y)
#define ltotf8(x, y)	ltoieeef(x, y)
#define ttolf8(x, y)	ieeetolf(x, y)
#define mltotf4(x, l)	mltoieeef(x, l)
#define mttolf4(x, l)	mieeetolf(x, l)
#define mltotf8(x, l)	mltoieeef(x, l)
#define mttolf8(x, l)	mieeetolf(x, l)

#endif /* not HAVE_IEEE_FP */

#ifdef __cplusplus
extern "C" {
#endif

extern uint4		rw __ARGS((uint4 oword));
extern void		rev4 __ARGS((void *src, void *dest));
extern void		rev8 __ARGS((void *src, void *dest));
extern void		revn __ARGS((void *src, void *dest, int size));
extern void		mrev4 __ARGS((void *array, int num));
extern void		mrev8 __ARGS((void *array, int num));
extern void		mrevn __ARGS((void *array, int size, int num));
extern void		ltoieeef __ARGS((float *src, void *dest));
extern void		ltoieeed __ARGS((double *src, void *dest));
extern void		ieeetolf __ARGS((void *src, float *dest));
extern void		ieeetold __ARGS((void *src, double *dest));
extern void		mltoieeef __ARGS((float *array, int num));
extern void		mltoieeed __ARGS((double *array, int num));
extern void		mieeetolf __ARGS((float *array, int num));
extern void		mieeetold __ARGS((double *array, int num));

#if LAM_SIZEOF_LONG_DOUBLE
extern void		ltoieeeld __ARGS((LAM_LONG_DOUBLE *src, void *dest));
extern void		ieeetolld __ARGS((void *src, LAM_LONG_DOUBLE *dest));
extern void		mltoieeeld __ARGS((LAM_LONG_DOUBLE *array, int num));
extern void		mieeetolld __ARGS((LAM_LONG_DOUBLE *array, int num));
#endif

#ifdef __cplusplus
}
#endif

#endif /* _T_TYPES */
