/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Arun Rodrigues, and Brian Barrett with
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted subject to the conditions specified in the
 * LICENSE file.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 * Additional copyrights may follow.
 * 
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	GDB/RBD
 *
 *	$Id: kattach.c,v 1.1 2000/02/08 09:32:38 jsquyres Exp $
 * 
 *	Function:	- attaches calling process to the kernel
 *	Accepts:	- process scheduling priority
 *	Returns:	- 0 or ERROR
 */
			  
#include <lam_config.h>

#include <signal.h>
#include <unistd.h>

#include <kio.h>
#include <kreq.h>
#include <typical.h>

/*
 * external variables
 */
extern struct kio_t	_kio;			/* Kernel I/O block */
extern int		errno;

/*
 * external functions
 */
extern int		_cio_kreq();		/* make kernel request */
extern void		_ksig_follow();		/* follow signals */

int
kattach(priority)

int			priority;

{
	struct kreq	req;		/* kernel request */
	struct kreply	reply;		/* kernel reply */
	sigset_t	newset;		/* new signal set */
	sigset_t	oldset;		/* old signal set */

	LAM_ZERO_ME(req);
	LAM_ZERO_ME(reply);
	req.kq_req = KQATTACH;
	req.kq_index = _kio.ki_index;
	req.kq_pid = getpid();
	req.kq_priority = priority;
/*
 * Send the request to the kernel and receive a reply.
 */
	sigemptyset(&newset);
	sigaddset(&newset, LAM_SIGUSR);
	sigprocmask(SIG_BLOCK, &newset, &oldset);

	if (_cio_kreq(&req, &reply)) {
		sigprocmask(SIG_SETMASK, &oldset, (sigset_t *) 0);
		return(LAMERROR);
	}

	if (reply.kr_reply) {
		sigprocmask(SIG_SETMASK, &oldset, (sigset_t *) 0);
		errno = reply.kr_reply;
		return(LAMERROR);
	}

	_kio.ki_index = reply.kr_index;
	_kio.ki_rtf |= RTF_KERNEL;	
	_kio.ki_pid = getpid();	
	_kio.ki_priority = priority;
	sigprocmask(SIG_SETMASK, &oldset, (sigset_t *) 0);

	if (reply.kr_signal) {
		_kio.ki_signal |= reply.kr_signal;
		_ksig_follow();
	}

	return(0);
}
