/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Arun Rodrigues, and Brian Barrett with
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted subject to the conditions specified in the
 * LICENSE file.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 * Additional copyrights may follow.
 * 
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	GDB/RBD
 *
 *	$Id: kdetach.c,v 1.1 2000/02/08 09:32:39 jsquyres Exp $
 * 
 *	Function:	- detaches calling process from the kernel
 *	Accepts:	- process scheduling priority
 *	Returns:	- 0 or ERROR
 */
			  
#include <kio.h>
#include <kreq.h>
#include <terror.h>
#include <typical.h>

#include <unistd.h>

/*
 * external variables
 */
extern struct kio_t	_kio;			/* Kernel I/O block */

/*
 * external functions
 */
extern int		_cio_kreqfront();	/* make kernel request */

int
kdetach(pid)

int			pid;

{
	struct kreq	req;			/* kernel request */

	if (_kio.ki_pid != getpid()) {
		errno = ENOTATTACHED;	
		return(ERROR);
	}

	LAM_ZERO_ME(req);
	req.kq_req = KQDETACH;
	req.kq_index = _kio.ki_index;
	req.kq_pid = (pid == 0) ? getpid() : pid;

	if (_cio_kreqfront(&req) < 0) {
		return(ERROR);
	}

	if ((pid == 0) || (pid == getpid())) {
		_kio.ki_rtf &= ~RTF_KERNEL;	
		_kio.ki_pid = -1;	
		_kio.ki_index = -1;
	}

	return(0);
}
