/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Arun Rodrigues, and Brian Barrett with
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted subject to the conditions specified in the
 * LICENSE file.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 * Additional copyrights may follow.
 * 
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	NJN
 *
 *	$Id: lampublish.c,v 1.0 1999/07/21 19:00:13 jsquyres Exp $
 *
 *	Function:	- LAM MPI name publishing
 *			- all MPI services are published on node 0
 */

#include <lam_config.h>
#include <app_mgmt.h>
#include <mpisys.h>
#include <rpisys.h>
#include <trreq.h>

/*
 *	lam_publish
 *
 *	Function:	- publish a service
 *	Accepts:	- service name
 *			- service port
 *	Returns:	- 0 or LAMERROR
 */
int
lam_publish(name, port)

char			*name;
char			*port;

{
	int4		id;			/* name publishing ID */

	id = (int4) ((lam_myproc->p_gps.gps_pid << 16)
			| lam_myproc->p_gps.gps_node);

	return(lam_rtrnamepub(0, id, name, port));
}

/*
 *	lam_unpublish
 *
 *	Function:	- un-publish a service
 *	Accepts:	- service name
 *	Returns:	- 0 or LAMERROR
 */
int
lam_unpublish(name)

char			*name;

{
	return(lam_rtrnamedel(0, name));
}

/*
 *	lam_getpublished
 *
 *	Function:	- get a published port
 *			- allocates storage for the port
 *	Accepts:	- service name
 *			- service port (out)
 *	Returns:	- 0 or LAMERROR
 */
int
lam_getpublished(name, port)

char			*name;
char			**port;

{
	return(lam_rtrnameget(0, name, port));
}

/*
 *	lam_nukepublished
 *
 *	Function:	- nuke all names published by caller
 */
void
lam_nukepublished()

{
	int4		id;			/* name publishing ID */

	id = (int4) ((lam_myproc->p_gps.gps_pid << 16)
			| lam_myproc->p_gps.gps_node);

	lam_rtrnamesweep(0, id);
}
