/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Arun Rodrigues, and Brian Barrett with
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted subject to the conditions specified in the
 * LICENSE file.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 * Additional copyrights may follow.
 * 
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	NJN
 *
 *	$Id: wgetattr.c,v 1.3 2001/02/03 20:30:00 jsquyres Exp $
 *
 *	Function:	- get window attribute value
 *	Accepts:	- window
 *			- attribute key
 *			- attribute value (out)
 *			- found flag (out)
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>


/*@
    MPI_Win_get_attr - Get window attribute value

Input Parameters:
+ win - Window to which attribute is attached
- key - key value

Output Parameters:
+ value - attribute value, unless found = false
- found - false if no attribute is associated with the key 

.N fortran

.N Errors
.N MPI_SUCCESS
.N MPI_ERR_WIN
.N MPI_ERR_KEYVAL

.seealso MPI_Win_create_keyval(3), MPI_Win_free_keyval(3), MPI_Win_set_attr(3), MPI_Win_delete_attr(3)

.N WEB
@*/
int
MPI_Win_get_attr(MPI_Win win, int key, void *value, int *found)
{
        struct _attrkey *pk;
	struct _attr    *p;

	lam_initerr_m();
	lam_setfunc_m(BLKMPIWINGETATTR);
/*
* Check the arguments.
*/
	if (win == MPI_WIN_NULL) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPIWINGETATTR, lam_mkerr(MPI_ERR_WIN, 0)));
	}

	if ((value == 0) || (found == 0)) {
		return(lam_errfunc(win->w_comm,
			BLKMPIWINGETATTR, lam_mkerr(MPI_ERR_ARG, 0)));
	}

	pk = lam_getattr(key);
	if (pk == 0 || !(pk->ak_flags & LAM_AKWIN)) {
		return(lam_errfunc(win->w_comm,
			BLKMPIWINGETATTR, lam_mkerr(MPI_ERR_KEYVAL, 0)));
	}
/*
 * Check if the key is attached to the window.
 */
	p = lam_getkey(win->w_keys, key);
	if (p == 0) {
		*found = 0;
	} else {
		*found = 1;
/*
 * This stuff is very confusing.  Be sure to see MPI-2 4.12.7.
 */
		*((void **) value) = (pk->ak_flags & LAM_LANGF77)
			? (void *) &p->a_value : p->a_value;
	}

	lam_resetfunc_m(BLKMPIWINGETATTR);
	return(MPI_SUCCESS);
}
