/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Arun Rodrigues, and Brian Barrett with
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted subject to the conditions specified in the
 * LICENSE file.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 * Additional copyrights may follow.
 * 
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	NJN
 *
 *	$Id: wgroup.c,v 1.1 2001/02/03 20:51:49 arodrig6 Exp $
 *
 *	Function:	- get window group
 *	Accepts:	- window
 *			- group (out)
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>

/*@
MPI_Win_get_group - Returns a duplicate of the group of a window

Input Parameters:
+ win - window object (handle) 
- group - group of processes which share access to the window (handle) 

Notes:

MPI_WIN_GET_GROUP returns a duplicate of the group of the communicator
used to create the window. associated with win. The group is returned
in group.

.N fortran
.N IMPI_MPI2

.N Errors
.N MPI_SUCCESS
.N MPI_ERR_WIN
.N MPI_ERR_ARG

.seealso MPI_Put(3), MPI_Get(3), MPI_Win_create(3), MPI_Win_start(3), MPI_Win_complete(3), MPI_Win_fence(3), MPI_Win_free(3), MPI_Accumulate(3), MPI_Win_get_group(3), MPI_Win_wait(3)

.N WEB
  @*/

int MPI_Win_get_group(MPI_Win win, MPI_Group *group)
{
	lam_initerr();
	lam_setfunc(BLKMPIWINGETGROUP);

	if (win == MPI_WIN_NULL) {
		return(lam_err_comm(MPI_COMM_WORLD,
		    			MPI_ERR_WIN, 0, "null handle"));
	}

	if (group == 0) {
		return(lam_err_win(win, MPI_ERR_ARG, 0, "null group pointer"));
	}

	*group = win->w_comm->c_group;
	win->w_comm->c_group->g_refcount++;

	lam_resetfunc(BLKMPIWINGETGROUP);
  	return(MPI_SUCCESS);
}
