/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Arun Rodrigues, and Brian Barrett with
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted subject to the conditions specified in the
 * LICENSE file.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 * Additional copyrights may follow.
 * 
 *	Ohio Trollius
 *	Copyright 1995 The Ohio State University
 *	GDB/RBD
 *
 *	$Id: dsend.c,v 6.3 1999/09/10 05:21:57 jsquyres Exp $
 *
 *	Function:	- sends a message at the datalink sublayer
 */

#include <net.h>

int
dsend(nhead)

struct nmsg		*nhead;

{
	struct kmsg	khead;		/* kernel message descriptor */	
	int4		mynodeid;
/*
 * Set up kernel message descriptor to send the network frame header.
 */
	khead.k_event = nhead->nh_dl_event;
	khead.k_length = nhead->nh_length;
/*
 * Categorize the message.
 * We must allow LOCAL to fall through before calling the router.
 */
	mynodeid = (nhead->nh_node == LOCAL) ? LOCAL : getnodeid();

	if ((nhead->nh_dl_event == nhead->nh_event) &&
			(nhead->nh_node == mynodeid)) {
		khead.k_type = nhead->nh_type;
		khead.k_flags = KNMSG | nhead->nh_flags;
	} else {
		khead.k_type = (nhead->nh_event >= 0) ? DLUSR : DLSYS;
		khead.k_flags = KNMSG | (nhead->nh_flags & (KTRY | KTRACE));

		if (nhead->nh_flags & DDLI) {
			khead.k_type |= DLI;
			nhead->nh_flags &= ~DDLI;
		}
	}

	khead.k_msg = (char *) nhead;

	return(ksend(&khead));
}

/*
 *	dtry_send
 *
 *	Function:	- non-blocking dsend()
 *	Accepts:	- ptr to network message descriptor
 *	Returns:	- 0 or ERROR
 */
int
dtry_send(nhead)

struct nmsg		*nhead;

{
	int		ret;

	nhead->nh_flags |= KTRY;
	ret = dsend(nhead);
	nhead->nh_flags &= ~KTRY;
	return(ret);
}
