/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Arun Rodrigues, and Brian Barrett with
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted subject to the conditions specified in the
 * LICENSE file.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 * Additional copyrights may follow.
 * 
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	GDB
 *
 *	$Id: lpdetach.c,v 6.5 1999/07/28 00:32:08 jsquyres Exp $
 *
 *	Function:	- detaches caller from the local kenya server
 *			- based on Trollius 2.0 Copyright 1990
 *			  The Ohio State University and Cornell
 *			  Research Foundation
 *	Accepts:	- target process ID
 *			- exit status
 *	Returns:	- 0 or ERROR
 */

#include <events.h>
#include <kio.h>
#include <ksignal.h>
#include <net.h>
#include <portable.h>
#include <preq.h>
#include <t_types.h>
#include <typical.h>
#include <terror.h>

#include <unistd.h>

/*
 * external variables
 */
extern struct kio_t	_kio;		/* Kernel Input/Output */

int
lpdetach(pid, status)

int			pid;
int			status;

{
	struct nmsg	nhead;		/* network header */
	struct preq  	request;	/* kenya request */
	struct preply	reply;		/* kenya reply */
	int		mask;

	LAM_ZERO_ME(nhead);
	LAM_ZERO_ME(request);
	LAM_ZERO_ME(reply);

	request.pq_src_node = ltot(LOCAL);
	request.pq_src_event = ltot((int4) -getpid());
	request.pq_pid = ltot(pid ? (int4) pid : (int4) getpid());
	request.pq_status = ltot((int4) status);
	request.pq_req = ltot(PQDETACH);

	nhead.nh_node = LOCAL;
	nhead.nh_event = EVKENYAD;
	nhead.nh_type = 0;
	nhead.nh_flags = 0;
	nhead.nh_length = sizeof(request);
	nhead.nh_msg = (char *) &request;
	mask = ksigblock(sigmask(SIGUDIE) | sigmask(SIGARREST));

	if (nsend(&nhead)) {
		ksigsetmask(mask);
		return(ERROR);
	}

	nhead.nh_event = -getpid();
	nhead.nh_flags = 0;
	nhead.nh_length = sizeof(reply);
	nhead.nh_msg = (char *) &reply;

	if (nrecv(&nhead)) {
		ksigsetmask(mask);
		return(ERROR);
	}

	ksigsetmask(mask);

	if (reply.pr_reply) {
		errno = ttol(reply.pr_reply);
		return(ERROR);
	} else {
		_kio.ki_rtf &= ~RTF_KENYA;
		return(0);
	}
}

/*
 *	rpdetach
 *
 *	Function:	- now just a wrapper for lpdetach()
 *			- obsolete; don't use this, use lpdetach()
 *	Accepts:	- destination node
 *			- target process ID
 *			- exit status
 *	Returns:	- 0 or ERROR
 */
int
rpdetach(node, pid, status)

int4			node;
int			pid;
int			status;

{
	if ((node != LOCAL) && (node != getnodeid())) {
		errno = EBADNODE;
		return(ERROR);
	}

	return(lpdetach(pid, status));
}
