.TH  DLASD6 1 "November 2008" " LAPACK auxiliary routine (version 3.2) " " LAPACK auxiliary routine (version 3.2) " 
.SH NAME
DLASD6 - computes the SVD of an updated upper bidiagonal matrix B obtained by merging two smaller ones by appending a row
.SH SYNOPSIS
.TP 19
SUBROUTINE DLASD6(
ICOMPQ, NL, NR, SQRE, D, VF, VL, ALPHA, BETA,
IDXQ, PERM, GIVPTR, GIVCOL, LDGCOL, GIVNUM,
LDGNUM, POLES, DIFL, DIFR, Z, K, C, S, WORK,
IWORK, INFO )
.TP 19
.ti +4
INTEGER
GIVPTR, ICOMPQ, INFO, K, LDGCOL, LDGNUM, NL,
NR, SQRE
.TP 19
.ti +4
DOUBLE
PRECISION ALPHA, BETA, C, S
.TP 19
.ti +4
INTEGER
GIVCOL( LDGCOL, * ), IDXQ( * ), IWORK( * ),
PERM( * )
.TP 19
.ti +4
DOUBLE
PRECISION D( * ), DIFL( * ), DIFR( * ),
GIVNUM( LDGNUM, * ), POLES( LDGNUM, * ),
VF( * ), VL( * ), WORK( * ), Z( * )
.SH PURPOSE
DLASD6 computes the SVD of an updated upper bidiagonal matrix B
obtained by merging two smaller ones by appending a row. This
routine is used only for the problem which requires all singular
values and optionally singular vector matrices in factored form.
B is an N-by-M matrix with N = NL + NR + 1 and M = N + SQRE.
A related subroutine, DLASD1, handles the case in which all singular
values and singular vectors of the bidiagonal matrix are desired.
DLASD6 computes the SVD as follows:
.br
              ( D1(in)  0    0     0 )
.br
  B = U(in) * (   Z1\(aq   a   Z2\(aq    b ) * VT(in)
.br
              (   0     0   D2(in) 0 )
.br
    = U(out) * ( D(out) 0) * VT(out)
.br
where Z\(aq = (Z1\(aq a Z2\(aq b) = u\(aq VT\(aq, and u is a vector of dimension M
with ALPHA and BETA in the NL+1 and NL+2 th entries and zeros
elsewhere; and the entry b is empty if SQRE = 0.
.br
The singular values of B can be computed using D1, D2, the first
components of all the right singular vectors of the lower block, and
the last components of all the right singular vectors of the upper
block. These components are stored and updated in VF and VL,
respectively, in DLASD6. Hence U and VT are not explicitly
referenced.
.br
The singular values are stored in D. The algorithm consists of two
stages:
.br
      The first stage consists of deflating the size of the problem
      when there are multiple singular values or if there is a zero
      in the Z vector. For each such occurence the dimension of the
      secular equation problem is reduced by one. This stage is
      performed by the routine DLASD7.
.br
      The second stage consists of calculating the updated
      singular values. This is done by finding the roots of the
      secular equation via the routine DLASD4 (as called by DLASD8).
      This routine also updates VF and VL and computes the distances
      between the updated singular values and the old singular
      values.
.br
DLASD6 is called from DLASDA.
.br
.SH ARGUMENTS
ICOMPQ (input) INTEGER
Specifies whether singular vectors are to be computed in
factored form:
.br
= 0: Compute singular values only.
.br
= 1: Compute singular vectors in factored form as well.
.TP 7
NL     (input) INTEGER
The row dimension of the upper block.  NL >= 1.
.TP 7
NR     (input) INTEGER
The row dimension of the lower block.  NR >= 1.
.TP 7
SQRE   (input) INTEGER
= 0: the lower block is an NR-by-NR square matrix.
.br
= 1: the lower block is an NR-by-(NR+1) rectangular matrix.
The bidiagonal matrix has row dimension N = NL + NR + 1,
and column dimension M = N + SQRE.
.TP 7
D      (input/output) DOUBLE PRECISION array, dimension ( NL+NR+1 ).
On entry D(1:NL,1:NL) contains the singular values of the
.br
upper block, and D(NL+2:N) contains the singular values
.br
of the lower block. On exit D(1:N) contains the singular
values of the modified matrix.
.TP 7
VF     (input/output) DOUBLE PRECISION array, dimension ( M )
On entry, VF(1:NL+1) contains the first components of all
.br
right singular vectors of the upper block; and VF(NL+2:M)
contains the first components of all right singular vectors
of the lower block. On exit, VF contains the first components
of all right singular vectors of the bidiagonal matrix.
.TP 7
VL     (input/output) DOUBLE PRECISION array, dimension ( M )
On entry, VL(1:NL+1) contains the  last components of all
.br
right singular vectors of the upper block; and VL(NL+2:M)
contains the last components of all right singular vectors of
the lower block. On exit, VL contains the last components of
all right singular vectors of the bidiagonal matrix.
.TP 7
ALPHA  (input/output) DOUBLE PRECISION
Contains the diagonal element associated with the added row.
.TP 7
BETA   (input/output) DOUBLE PRECISION
Contains the off-diagonal element associated with the added
row.
.TP 7
IDXQ   (output) INTEGER array, dimension ( N )
This contains the permutation which will reintegrate the
subproblem just solved back into sorted order, i.e.
D( IDXQ( I = 1, N ) ) will be in ascending order.
.TP 7
PERM   (output) INTEGER array, dimension ( N )
The permutations (from deflation and sorting) to be applied
to each block. Not referenced if ICOMPQ = 0.
GIVPTR (output) INTEGER
The number of Givens rotations which took place in this
subproblem. Not referenced if ICOMPQ = 0.
GIVCOL (output) INTEGER array, dimension ( LDGCOL, 2 )
Each pair of numbers indicates a pair of columns to take place
in a Givens rotation. Not referenced if ICOMPQ = 0.
LDGCOL (input) INTEGER
leading dimension of GIVCOL, must be at least N.
GIVNUM (output) DOUBLE PRECISION array, dimension ( LDGNUM, 2 )
Each number indicates the C or S value to be used in the
corresponding Givens rotation. Not referenced if ICOMPQ = 0.
LDGNUM (input) INTEGER
The leading dimension of GIVNUM and POLES, must be at least N.
.TP 7
POLES  (output) DOUBLE PRECISION array, dimension ( LDGNUM, 2 )
On exit, POLES(1,*) is an array containing the new singular
values obtained from solving the secular equation, and
POLES(2,*) is an array containing the poles in the secular
equation. Not referenced if ICOMPQ = 0.
.TP 7
DIFL   (output) DOUBLE PRECISION array, dimension ( N )
On exit, DIFL(I) is the distance between I-th updated
(undeflated) singular value and the I-th (undeflated) old
singular value.
.TP 7
DIFR   (output) DOUBLE PRECISION array,
dimension ( LDGNUM, 2 ) if ICOMPQ = 1 and
dimension ( N ) if ICOMPQ = 0.
On exit, DIFR(I, 1) is the distance between I-th updated
(undeflated) singular value and the I+1-th (undeflated) old
singular value.
If ICOMPQ = 1, DIFR(1:K,2) is an array containing the
normalizing factors for the right singular vector matrix.
See DLASD8 for details on DIFL and DIFR.
.TP 7
Z      (output) DOUBLE PRECISION array, dimension ( M )
The first elements of this array contain the components
of the deflation-adjusted updating row vector.
.TP 7
K      (output) INTEGER
Contains the dimension of the non-deflated matrix,
This is the order of the related secular equation. 1 <= K <=N.
.TP 7
C      (output) DOUBLE PRECISION
C contains garbage if SQRE =0 and the C-value of a Givens
rotation related to the right null space if SQRE = 1.
.TP 7
S      (output) DOUBLE PRECISION
S contains garbage if SQRE =0 and the S-value of a Givens
rotation related to the right null space if SQRE = 1.
.TP 7
WORK   (workspace) DOUBLE PRECISION array, dimension ( 4 * M )
.TP 7
IWORK  (workspace) INTEGER array, dimension ( 3 * N )
.TP 7
INFO   (output) INTEGER
= 0:  successful exit.
.br
< 0:  if INFO = -i, the i-th argument had an illegal value.
.br
> 0:  if INFO = 1, an singular value did not converge
.SH FURTHER DETAILS
Based on contributions by
.br
   Ming Gu and Huan Ren, Computer Science Division, University of
   California at Berkeley, USA
.br
