.TH DSTEGR l "15 June 2000" "LAPACK computational version 3.0" ")"
.SH NAME
DSTEGR - compute selected eigenvalues and, optionally, eigenvectors of a real symmetric tridiagonal matrix T
.SH SYNOPSIS
.TP 19
SUBROUTINE DSTEGR(
JOBZ, RANGE, N, D, E, VL, VU, IL, IU, ABSTOL,
M, W, Z, LDZ, ISUPPZ, WORK, LWORK, IWORK,
LIWORK, INFO )
.TP 19
.ti +4
CHARACTER
JOBZ, RANGE
.TP 19
.ti +4
INTEGER
IL, INFO, IU, LDZ, LIWORK, LWORK, M, N
.TP 19
.ti +4
DOUBLE
PRECISION ABSTOL, VL, VU
.TP 19
.ti +4
INTEGER
ISUPPZ( * ), IWORK( * )
.TP 19
.ti +4
DOUBLE
PRECISION D( * ), E( * ), W( * ), WORK( * ), Z( LDZ, * )
.SH PURPOSE
DSTEGR computes selected eigenvalues and, optionally, eigenvectors of a real symmetric tridiagonal matrix T. Eigenvalues and 






   (a) Compute T - sigma_i = L_i D_i L_i^T, such that L_i D_i L_i^T
       is a relatively robust representation,
.br
   (b) Compute the eigenvalues, lambda_j, of L_i D_i L_i^T to high
       relative accuracy by the dqds algorithm,
.br
   (c) If there is a cluster of close eigenvalues, "choose" sigma_i
       close to the cluster, and go to step (a),
.br
   (d) Given the approximate eigenvalue lambda_j of L_i D_i L_i^T,
       compute the corresponding eigenvector by forming a
       rank-revealing twisted factorization.
.br
The desired accuracy of the output can be specified by the input
parameter ABSTOL.
.br

For more details, see "A new O(n^2) algorithm for the symmetric
tridiagonal eigenvalue/eigenvector problem", by Inderjit Dhillon,
Computer Science Division Technical Report No. UCB/CSD-97-971,
UC Berkeley, May 1997.
.br

Note 1 : Currently DSTEGR is only set up to find ALL the n
eigenvalues and eigenvectors of T in O(n^2) time
.br
Note 2 : Currently the routine DSTEIN is called when an appropriate
sigma_i cannot be chosen in step (c) above. DSTEIN invokes modified
Gram-Schmidt when eigenvalues are close.
.br
Note 3 : DSTEGR works only on machines which follow ieee-754
floating-point standard in their handling of infinities and NaNs.
Normal execution of DSTEGR may create NaNs and infinities and hence
may abort due to a floating point exception in environments which
do not conform to the ieee standard.
.br

.SH ARGUMENTS
.TP 8
JOBZ    (input) CHARACTER*1
= 'N':  Compute eigenvalues only;
.br
= 'V':  Compute eigenvalues and eigenvectors.
.TP 8
RANGE   (input) CHARACTER*1
.br
= 'A': all eigenvalues will be found.
.br
= 'V': all eigenvalues in the half-open interval (VL,VU]
will be found.
= 'I': the IL-th through IU-th eigenvalues will be found.
.TP 8
N       (input) INTEGER
The order of the matrix.  N >= 0.
.TP 8
D       (input/output) DOUBLE PRECISION array, dimension (N)
On entry, the n diagonal elements of the tridiagonal matrix
T. On exit, D is overwritten.
.TP 8
E       (input/output) DOUBLE PRECISION array, dimension (N)
On entry, the (n-1) subdiagonal elements of the tridiagonal
matrix T in elements 1 to N-1 of E; E(N) need not be set.
On exit, E is overwritten.
.TP 8
VL      (input) DOUBLE PRECISION
VU      (input) DOUBLE PRECISION
If RANGE='V', the lower and upper bounds of the interval to
be searched for eigenvalues. VL < VU.
Not referenced if RANGE = 'A' or 'I'.
.TP 8
IL      (input) INTEGER
IU      (input) INTEGER
If RANGE='I', the indices (in ascending order) of the
smallest and largest eigenvalues to be returned.
1 <= IL <= IU <= N, if N > 0; IL = 1 and IU = 0 if N = 0.
Not referenced if RANGE = 'A' or 'V'.
.TP 8
ABSTOL  (input) DOUBLE PRECISION
The absolute error tolerance for the
eigenvalues/eigenvectors. IF JOBZ = 'V', the eigenvalues and
eigenvectors output have residual norms bounded by ABSTOL,
and the dot products between different eigenvectors are
bounded by ABSTOL. If ABSTOL is less than N*EPS*|T|, then
N*EPS*|T| will be used in its place, where EPS is the
machine precision and |T| is the 1-norm of the tridiagonal
matrix. The eigenvalues are computed to an accuracy of
EPS*|T| irrespective of ABSTOL. If high relative accuracy
is important, set ABSTOL to DLAMCH( 'Safe minimum' ).
See Barlow and Demmel "Computing Accurate Eigensystems of
Scaled Diagonally Dominant Matrices", LAPACK Working Note #7
for a discussion of which matrices define their eigenvalues
to high relative accuracy.
.TP 8
M       (output) INTEGER
The total number of eigenvalues found.  0 <= M <= N.
If RANGE = 'A', M = N, and if RANGE = 'I', M = IU-IL+1.
.TP 8
W       (output) DOUBLE PRECISION array, dimension (N)
The first M elements contain the selected eigenvalues in
ascending order.
.TP 8
Z       (output) DOUBLE PRECISION array, dimension (LDZ, max(1,M) )
If JOBZ = 'V', then if INFO = 0, the first M columns of Z
contain the orthonormal eigenvectors of the matrix T
corresponding to the selected eigenvalues, with the i-th
column of Z holding the eigenvector associated with W(i).
If JOBZ = 'N', then Z is not referenced.
Note: the user must ensure that at least max(1,M) columns are
supplied in the array Z; if RANGE = 'V', the exact value of M
is not known in advance and an upper bound must be used.
.TP 8
LDZ     (input) INTEGER
The leading dimension of the array Z.  LDZ >= 1, and if
JOBZ = 'V', LDZ >= max(1,N).
.TP 8
ISUPPZ  (output) INTEGER ARRAY, dimension ( 2*max(1,M) )
The support of the eigenvectors in Z, i.e., the indices
indicating the nonzero elements in Z. The i-th eigenvector
is nonzero only in elements ISUPPZ( 2*i-1 ) through
ISUPPZ( 2*i ).
.TP 8
WORK    (workspace/output) DOUBLE PRECISION array, dimension (LWORK)
On exit, if INFO = 0, WORK(1) returns the optimal
(and minimal) LWORK.
.TP 8
LWORK   (input) INTEGER
The dimension of the array WORK.  LWORK >= max(1,18*N)

If LWORK = -1, then a workspace query is assumed; the routine
only calculates the optimal size of the WORK array, returns
this value as the first entry of the WORK array, and no error
message related to LWORK is issued by XERBLA.
.TP 8
IWORK   (workspace/output) INTEGER array, dimension (LIWORK)
On exit, if INFO = 0, IWORK(1) returns the optimal LIWORK.
.TP 8
LIWORK  (input) INTEGER
The dimension of the array IWORK.  LIWORK >= max(1,10*N)

If LIWORK = -1, then a workspace query is assumed; the
routine only calculates the optimal size of the IWORK array,
returns this value as the first entry of the IWORK array, and
no error message related to LIWORK is issued by XERBLA.
.TP 8
INFO    (output) INTEGER
= 0:  successful exit
.br
< 0:  if INFO = -i, the i-th argument had an illegal value
.br
> 0:  if INFO = 1, internal error in DLARRE,
if INFO = 2, internal error in DLARRV.
.SH FURTHER DETAILS
Based on contributions by
.br
   Inderjit Dhillon, IBM Almaden, USA
.br
   Osni Marques, LBNL/NERSC, USA
.br

