/***************************************************************************
 *   Copyright (C) 2005 - 2006 by Christian Muehlhaeuser, Last.fm Ltd.     *
 *   chris@last.fm                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02111-1307, USA.          *
 ***************************************************************************/

#include "imagebutton.h"


ImageButton::ImageButton( QWidget *parent )
    : QLabel( parent )
{
    state = true;
}


void
ImageButton::setImages( QString prefix, QString normal, QString down, QString hover, QString disabled )
{
    this->normal.load  ( prefix + normal );
    this->down.load    ( prefix + down );
    this->hover.load   ( prefix + hover );
    this->disabled.load( prefix + disabled );

    this->setPixmap( this->normal );
}


void
ImageButton::setEnabled( bool enabled )
{
    state = enabled;
    this->setPixmap( enabled ? this->normal : this->disabled );
}


void
ImageButton::mousePressEvent( QMouseEvent *e )
{
    if ( state )
        this->setPixmap( down );
}


void
ImageButton::mouseReleaseEvent( QMouseEvent * e )
{
    if ( state )
    {
        setEnabled( state );
        emit clicked();
    }
}


void
ImageButton::enterEvent( QEvent * e )
{
    if ( state )
        this->setPixmap( hover );
}


void
ImageButton::leaveEvent( QEvent *e )
{
    setEnabled( state );
}

